/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.Architecture;
import software.amazon.awssdk.services.opsworks.model.AutoScalingType;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateInstanceRequest> {
    private final String instanceId;
    private final List<String> layerIds;
    private final String instanceType;
    private final String autoScalingType;
    private final String hostname;
    private final String os;
    private final String amiId;
    private final String sshKeyName;
    private final String architecture;
    private final Boolean installUpdatesOnBoot;
    private final Boolean ebsOptimized;
    private final String agentVersion;

    private UpdateInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.layerIds = builder.layerIds;
        this.instanceType = builder.instanceType;
        this.autoScalingType = builder.autoScalingType;
        this.hostname = builder.hostname;
        this.os = builder.os;
        this.amiId = builder.amiId;
        this.sshKeyName = builder.sshKeyName;
        this.architecture = builder.architecture;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.ebsOptimized = builder.ebsOptimized;
        this.agentVersion = builder.agentVersion;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public AutoScalingType autoScalingType() {
        return AutoScalingType.fromValue(this.autoScalingType);
    }

    public String autoScalingTypeString() {
        return this.autoScalingType;
    }

    public String hostname() {
        return this.hostname;
    }

    public String os() {
        return this.os;
    }

    public String amiId() {
        return this.amiId;
    }

    public String sshKeyName() {
        return this.sshKeyName;
    }

    public Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public String architectureString() {
        return this.architecture;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.os());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureString());
        hashCode = 31 * hashCode + Objects.hashCode(this.installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceRequest)) {
            return false;
        }
        UpdateInstanceRequest other = (UpdateInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.layerIds(), other.layerIds()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.autoScalingTypeString(), other.autoScalingTypeString()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.os(), other.os()) && Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.sshKeyName(), other.sshKeyName()) && Objects.equals(this.architectureString(), other.architectureString()) && Objects.equals(this.installUpdatesOnBoot(), other.installUpdatesOnBoot()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.agentVersion(), other.agentVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.layerIds() != null) {
            sb.append("LayerIds: ").append(this.layerIds()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.autoScalingTypeString() != null) {
            sb.append("AutoScalingType: ").append(this.autoScalingTypeString()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.os() != null) {
            sb.append("Os: ").append(this.os()).append(",");
        }
        if (this.amiId() != null) {
            sb.append("AmiId: ").append(this.amiId()).append(",");
        }
        if (this.sshKeyName() != null) {
            sb.append("SshKeyName: ").append(this.sshKeyName()).append(",");
        }
        if (this.architectureString() != null) {
            sb.append("Architecture: ").append(this.architectureString()).append(",");
        }
        if (this.installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(this.installUpdatesOnBoot()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.agentVersion() != null) {
            sb.append("AgentVersion: ").append(this.agentVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "LayerIds": {
                return Optional.of(clazz.cast(this.layerIds()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "AutoScalingType": {
                return Optional.of(clazz.cast(this.autoScalingTypeString()));
            }
            case "Hostname": {
                return Optional.of(clazz.cast(this.hostname()));
            }
            case "Os": {
                return Optional.of(clazz.cast(this.os()));
            }
            case "AmiId": {
                return Optional.of(clazz.cast(this.amiId()));
            }
            case "SshKeyName": {
                return Optional.of(clazz.cast(this.sshKeyName()));
            }
            case "Architecture": {
                return Optional.of(clazz.cast(this.architectureString()));
            }
            case "InstallUpdatesOnBoot": {
                return Optional.of(clazz.cast(this.installUpdatesOnBoot()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "AgentVersion": {
                return Optional.of(clazz.cast(this.agentVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private List<String> layerIds;
        private String instanceType;
        private String autoScalingType;
        private String hostname;
        private String os;
        private String amiId;
        private String sshKeyName;
        private String architecture;
        private Boolean installUpdatesOnBoot;
        private Boolean ebsOptimized;
        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceRequest model) {
            this.instanceId(model.instanceId);
            this.layerIds(model.layerIds);
            this.instanceType(model.instanceType);
            this.autoScalingType(model.autoScalingType);
            this.hostname(model.hostname);
            this.os(model.os);
            this.amiId(model.amiId);
            this.sshKeyName(model.sshKeyName);
            this.architecture(model.architecture);
            this.installUpdatesOnBoot(model.installUpdatesOnBoot);
            this.ebsOptimized(model.ebsOptimized);
            this.agentVersion(model.agentVersion);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAutoScalingType() {
            return this.autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public UpdateInstanceRequest build() {
            return new UpdateInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);

        public Builder instanceType(String var1);

        public Builder autoScalingType(String var1);

        public Builder autoScalingType(AutoScalingType var1);

        public Builder hostname(String var1);

        public Builder os(String var1);

        public Builder amiId(String var1);

        public Builder sshKeyName(String var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder agentVersion(String var1);
    }
}

