/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterVolumeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterVolumeRequest> {
    private final String ec2VolumeId;
    private final String stackId;

    private RegisterVolumeRequest(BuilderImpl builder) {
        this.ec2VolumeId = builder.ec2VolumeId;
        this.stackId = builder.stackId;
    }

    public String ec2VolumeId() {
        return this.ec2VolumeId;
    }

    public String stackId() {
        return this.stackId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2VolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterVolumeRequest)) {
            return false;
        }
        RegisterVolumeRequest other = (RegisterVolumeRequest)((Object)obj);
        return Objects.equals(this.ec2VolumeId(), other.ec2VolumeId()) && Objects.equals(this.stackId(), other.stackId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ec2VolumeId() != null) {
            sb.append("Ec2VolumeId: ").append(this.ec2VolumeId()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2VolumeId": {
                return Optional.of(clazz.cast(this.ec2VolumeId()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2VolumeId;
        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterVolumeRequest model) {
            this.ec2VolumeId(model.ec2VolumeId);
            this.stackId(model.stackId);
        }

        public final String getEc2VolumeId() {
            return this.ec2VolumeId;
        }

        @Override
        public final Builder ec2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
            return this;
        }

        public final void setEc2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public RegisterVolumeRequest build() {
            return new RegisterVolumeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterVolumeRequest> {
        public Builder ec2VolumeId(String var1);

        public Builder stackId(String var1);
    }
}

