/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.AutoScalingThresholds;
import software.amazon.awssdk.services.opsworks.transform.LoadBasedAutoScalingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBasedAutoScalingConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, LoadBasedAutoScalingConfiguration> {
    private final String layerId;
    private final Boolean enable;
    private final AutoScalingThresholds upScaling;
    private final AutoScalingThresholds downScaling;

    private LoadBasedAutoScalingConfiguration(BuilderImpl builder) {
        this.layerId = builder.layerId;
        this.enable = builder.enable;
        this.upScaling = builder.upScaling;
        this.downScaling = builder.downScaling;
    }

    public String layerId() {
        return this.layerId;
    }

    public Boolean enable() {
        return this.enable;
    }

    public AutoScalingThresholds upScaling() {
        return this.upScaling;
    }

    public AutoScalingThresholds downScaling() {
        return this.downScaling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        hashCode = 31 * hashCode + Objects.hashCode(this.upScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.downScaling());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBasedAutoScalingConfiguration)) {
            return false;
        }
        LoadBasedAutoScalingConfiguration other = (LoadBasedAutoScalingConfiguration)obj;
        return Objects.equals(this.layerId(), other.layerId()) && Objects.equals(this.enable(), other.enable()) && Objects.equals(this.upScaling(), other.upScaling()) && Objects.equals(this.downScaling(), other.downScaling());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.layerId() != null) {
            sb.append("LayerId: ").append(this.layerId()).append(",");
        }
        if (this.enable() != null) {
            sb.append("Enable: ").append(this.enable()).append(",");
        }
        if (this.upScaling() != null) {
            sb.append("UpScaling: ").append(this.upScaling()).append(",");
        }
        if (this.downScaling() != null) {
            sb.append("DownScaling: ").append(this.downScaling()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerId": {
                return Optional.of(clazz.cast(this.layerId()));
            }
            case "Enable": {
                return Optional.of(clazz.cast(this.enable()));
            }
            case "UpScaling": {
                return Optional.of(clazz.cast(this.upScaling()));
            }
            case "DownScaling": {
                return Optional.of(clazz.cast(this.downScaling()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBasedAutoScalingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerId;
        private Boolean enable;
        private AutoScalingThresholds upScaling;
        private AutoScalingThresholds downScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBasedAutoScalingConfiguration model) {
            this.layerId(model.layerId);
            this.enable(model.enable);
            this.upScaling(model.upScaling);
            this.downScaling(model.downScaling);
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final AutoScalingThresholds.Builder getUpScaling() {
            return this.upScaling != null ? this.upScaling.toBuilder() : null;
        }

        @Override
        public final Builder upScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
            return this;
        }

        public final void setUpScaling(AutoScalingThresholds.BuilderImpl upScaling) {
            this.upScaling = upScaling != null ? upScaling.build() : null;
        }

        public final AutoScalingThresholds.Builder getDownScaling() {
            return this.downScaling != null ? this.downScaling.toBuilder() : null;
        }

        @Override
        public final Builder downScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
            return this;
        }

        public final void setDownScaling(AutoScalingThresholds.BuilderImpl downScaling) {
            this.downScaling = downScaling != null ? downScaling.build() : null;
        }

        public LoadBasedAutoScalingConfiguration build() {
            return new LoadBasedAutoScalingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBasedAutoScalingConfiguration> {
        public Builder layerId(String var1);

        public Builder enable(Boolean var1);

        public Builder upScaling(AutoScalingThresholds var1);

        default public Builder upScaling(Consumer<AutoScalingThresholds.Builder> upScaling) {
            return this.upScaling((AutoScalingThresholds)((AutoScalingThresholds.Builder)AutoScalingThresholds.builder().apply(upScaling)).build());
        }

        public Builder downScaling(AutoScalingThresholds var1);

        default public Builder downScaling(Consumer<AutoScalingThresholds.Builder> downScaling) {
            return this.downScaling((AutoScalingThresholds)((AutoScalingThresholds.Builder)AutoScalingThresholds.builder().apply(downScaling)).build());
        }
    }
}

