/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateUserProfileRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateUserProfileRequest> {
    private final String iamUserArn;
    private final String sshUsername;
    private final String sshPublicKey;
    private final Boolean allowSelfManagement;

    private CreateUserProfileRequest(BuilderImpl builder) {
        this.iamUserArn = builder.iamUserArn;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
        this.allowSelfManagement = builder.allowSelfManagement;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String sshUsername() {
        return this.sshUsername;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public Boolean allowSelfManagement() {
        return this.allowSelfManagement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSelfManagement());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserProfileRequest)) {
            return false;
        }
        CreateUserProfileRequest other = (CreateUserProfileRequest)((Object)obj);
        return Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.sshUsername(), other.sshUsername()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.allowSelfManagement(), other.allowSelfManagement());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.iamUserArn() != null) {
            sb.append("IamUserArn: ").append(this.iamUserArn()).append(",");
        }
        if (this.sshUsername() != null) {
            sb.append("SshUsername: ").append(this.sshUsername()).append(",");
        }
        if (this.sshPublicKey() != null) {
            sb.append("SshPublicKey: ").append(this.sshPublicKey()).append(",");
        }
        if (this.allowSelfManagement() != null) {
            sb.append("AllowSelfManagement: ").append(this.allowSelfManagement()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamUserArn": {
                return Optional.of(clazz.cast(this.iamUserArn()));
            }
            case "SshUsername": {
                return Optional.of(clazz.cast(this.sshUsername()));
            }
            case "SshPublicKey": {
                return Optional.of(clazz.cast(this.sshPublicKey()));
            }
            case "AllowSelfManagement": {
                return Optional.of(clazz.cast(this.allowSelfManagement()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String iamUserArn;
        private String sshUsername;
        private String sshPublicKey;
        private Boolean allowSelfManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserProfileRequest model) {
            this.iamUserArn(model.iamUserArn);
            this.sshUsername(model.sshUsername);
            this.sshPublicKey(model.sshPublicKey);
            this.allowSelfManagement(model.allowSelfManagement);
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getSshUsername() {
            return this.sshUsername;
        }

        @Override
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Boolean getAllowSelfManagement() {
            return this.allowSelfManagement;
        }

        @Override
        public final Builder allowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
            return this;
        }

        public final void setAllowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
        }

        public CreateUserProfileRequest build() {
            return new CreateUserProfileRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateUserProfileRequest> {
        public Builder iamUserArn(String var1);

        public Builder sshUsername(String var1);

        public Builder sshPublicKey(String var1);

        public Builder allowSelfManagement(Boolean var1);
    }
}

