/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssignInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssignInstanceRequest> {
    private final String instanceId;
    private final List<String> layerIds;

    private AssignInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.layerIds = builder.layerIds;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignInstanceRequest)) {
            return false;
        }
        AssignInstanceRequest other = (AssignInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.layerIds(), other.layerIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.layerIds() != null) {
            sb.append("LayerIds: ").append(this.layerIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "LayerIds": {
                return Optional.of(clazz.cast(this.layerIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private List<String> layerIds;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignInstanceRequest model) {
            this.instanceId(model.instanceId);
            this.layerIds(model.layerIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public AssignInstanceRequest build() {
            return new AssignInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssignInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);
    }
}

