/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.Layer;
import software.amazon.awssdk.services.opsworks.model.LayersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLayersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLayersResponse> {
    private final List<Layer> layers;

    private DescribeLayersResponse(BuilderImpl builder) {
        this.layers = builder.layers;
    }

    public List<Layer> layers() {
        return this.layers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.layers() == null ? 0 : this.layers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersResponse)) {
            return false;
        }
        DescribeLayersResponse other = (DescribeLayersResponse)((Object)obj);
        if (other.layers() == null ^ this.layers() == null) {
            return false;
        }
        return other.layers() == null || other.layers().equals(this.layers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.layers() != null) {
            sb.append("Layers: ").append(this.layers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Layers": {
                return Optional.of(clazz.cast(this.layers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Layer> layers;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersResponse model) {
            this.layers(model.layers);
        }

        public final Collection<Layer.Builder> getLayers() {
            return this.layers != null ? (Collection)this.layers.stream().map(Layer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayersCopier.copyFromBuilder(layers);
        }

        public DescribeLayersResponse build() {
            return new DescribeLayersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLayersResponse> {
        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);
    }
}

