/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeInstancesRequest> {
    private final String stackId;
    private final String layerId;
    private final List<String> instanceIds;

    private DescribeInstancesRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.instanceIds = builder.instanceIds;
    }

    public String stackId() {
        return this.stackId;
    }

    public String layerId() {
        return this.layerId;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.layerId() == null ? 0 : this.layerId().hashCode());
        hashCode = 31 * hashCode + (this.instanceIds() == null ? 0 : this.instanceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesRequest)) {
            return false;
        }
        DescribeInstancesRequest other = (DescribeInstancesRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.layerId() == null ^ this.layerId() == null) {
            return false;
        }
        if (other.layerId() != null && !other.layerId().equals(this.layerId())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        return other.instanceIds() == null || other.instanceIds().equals(this.instanceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.layerId() != null) {
            sb.append("LayerId: ").append(this.layerId()).append(",");
        }
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "LayerId": {
                return Optional.of(clazz.cast(this.layerId()));
            }
            case "InstanceIds": {
                return Optional.of(clazz.cast(this.instanceIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String layerId;
        private List<String> instanceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesRequest model) {
            this.stackId(model.stackId);
            this.layerId(model.layerId);
            this.instanceIds(model.instanceIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        public DescribeInstancesRequest build() {
            return new DescribeInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancesRequest> {
        public Builder stackId(String var1);

        public Builder layerId(String var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);
    }
}

