/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEcsClustersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEcsClustersRequest> {
    private final List<String> ecsClusterArns;
    private final String stackId;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeEcsClustersRequest(BuilderImpl builder) {
        this.ecsClusterArns = builder.ecsClusterArns;
        this.stackId = builder.stackId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> ecsClusterArns() {
        return this.ecsClusterArns;
    }

    public String stackId() {
        return this.stackId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ecsClusterArns() == null ? 0 : this.ecsClusterArns().hashCode());
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersRequest)) {
            return false;
        }
        DescribeEcsClustersRequest other = (DescribeEcsClustersRequest)((Object)obj);
        if (other.ecsClusterArns() == null ^ this.ecsClusterArns() == null) {
            return false;
        }
        if (other.ecsClusterArns() != null && !other.ecsClusterArns().equals(this.ecsClusterArns())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ecsClusterArns() != null) {
            sb.append("EcsClusterArns: ").append(this.ecsClusterArns()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EcsClusterArns": {
                return Optional.of(clazz.cast(this.ecsClusterArns()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ecsClusterArns;
        private String stackId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersRequest model) {
            this.ecsClusterArns(model.ecsClusterArns);
            this.stackId(model.stackId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getEcsClusterArns() {
            return this.ecsClusterArns;
        }

        @Override
        public final Builder ecsClusterArns(Collection<String> ecsClusterArns) {
            this.ecsClusterArns = StringsCopier.copy(ecsClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusterArns(String ... ecsClusterArns) {
            this.ecsClusterArns(Arrays.asList(ecsClusterArns));
            return this;
        }

        public final void setEcsClusterArns(Collection<String> ecsClusterArns) {
            this.ecsClusterArns = StringsCopier.copy(ecsClusterArns);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public DescribeEcsClustersRequest build() {
            return new DescribeEcsClustersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEcsClustersRequest> {
        public Builder ecsClusterArns(Collection<String> var1);

        public Builder ecsClusterArns(String ... var1);

        public Builder stackId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

