/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.EbsBlockDevice;

public class EbsBlockDeviceUnmarshaller
implements Unmarshaller<EbsBlockDevice, JsonUnmarshallerContext> {
    private static final EbsBlockDeviceUnmarshaller INSTANCE = new EbsBlockDeviceUnmarshaller();

    public EbsBlockDevice unmarshall(JsonUnmarshallerContext context) throws Exception {
        EbsBlockDevice.Builder ebsBlockDeviceBuilder = EbsBlockDevice.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SnapshotId", targetDepth)) {
                    context.nextToken();
                    ebsBlockDeviceBuilder.snapshotId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Iops", targetDepth)) {
                    context.nextToken();
                    ebsBlockDeviceBuilder.iops((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("VolumeSize", targetDepth)) {
                    context.nextToken();
                    ebsBlockDeviceBuilder.volumeSize((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("VolumeType", targetDepth)) {
                    context.nextToken();
                    ebsBlockDeviceBuilder.volumeType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeleteOnTermination", targetDepth)) {
                    context.nextToken();
                    ebsBlockDeviceBuilder.deleteOnTermination((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EbsBlockDevice)ebsBlockDeviceBuilder.build();
    }

    public static EbsBlockDeviceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

