/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.PermissionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Permission
implements StructuredPojo,
ToCopyableBuilder<Builder, Permission> {
    private final String stackId;
    private final String iamUserArn;
    private final Boolean allowSsh;
    private final Boolean allowSudo;
    private final String level;

    private Permission(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.iamUserArn = builder.iamUserArn;
        this.allowSsh = builder.allowSsh;
        this.allowSudo = builder.allowSudo;
        this.level = builder.level;
    }

    public String stackId() {
        return this.stackId;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public Boolean allowSsh() {
        return this.allowSsh;
    }

    public Boolean allowSudo() {
        return this.allowSudo;
    }

    public String level() {
        return this.level;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.iamUserArn() == null ? 0 : this.iamUserArn().hashCode());
        hashCode = 31 * hashCode + (this.allowSsh() == null ? 0 : this.allowSsh().hashCode());
        hashCode = 31 * hashCode + (this.allowSudo() == null ? 0 : this.allowSudo().hashCode());
        hashCode = 31 * hashCode + (this.level() == null ? 0 : this.level().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        if (other.allowSsh() == null ^ this.allowSsh() == null) {
            return false;
        }
        if (other.allowSsh() != null && !other.allowSsh().equals(this.allowSsh())) {
            return false;
        }
        if (other.allowSudo() == null ^ this.allowSudo() == null) {
            return false;
        }
        if (other.allowSudo() != null && !other.allowSudo().equals(this.allowSudo())) {
            return false;
        }
        if (other.level() == null ^ this.level() == null) {
            return false;
        }
        return other.level() == null || other.level().equals(this.level());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.iamUserArn() != null) {
            sb.append("IamUserArn: ").append(this.iamUserArn()).append(",");
        }
        if (this.allowSsh() != null) {
            sb.append("AllowSsh: ").append(this.allowSsh()).append(",");
        }
        if (this.allowSudo() != null) {
            sb.append("AllowSudo: ").append(this.allowSudo()).append(",");
        }
        if (this.level() != null) {
            sb.append("Level: ").append(this.level()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PermissionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String iamUserArn;
        private Boolean allowSsh;
        private Boolean allowSudo;
        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            this.setStackId(model.stackId);
            this.setIamUserArn(model.iamUserArn);
            this.setAllowSsh(model.allowSsh);
            this.setAllowSudo(model.allowSudo);
            this.setLevel(model.level);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final Boolean getAllowSsh() {
            return this.allowSsh;
        }

        @Override
        public final Builder allowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public final void setAllowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
        }

        public final Boolean getAllowSudo() {
            return this.allowSudo;
        }

        @Override
        public final Builder allowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
            return this;
        }

        public final void setAllowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
        }

        public final String getLevel() {
            return this.level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public Permission build() {
            return new Permission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Permission> {
        public Builder stackId(String var1);

        public Builder iamUserArn(String var1);

        public Builder allowSsh(Boolean var1);

        public Builder allowSudo(Boolean var1);

        public Builder level(String var1);
    }
}

