/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.ParametersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStackProvisioningParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeStackProvisioningParametersResponse> {
    private final String agentInstallerUrl;
    private final Map<String, String> parameters;

    private DescribeStackProvisioningParametersResponse(BuilderImpl builder) {
        this.agentInstallerUrl = builder.agentInstallerUrl;
        this.parameters = builder.parameters;
    }

    public String agentInstallerUrl() {
        return this.agentInstallerUrl;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.agentInstallerUrl() == null ? 0 : this.agentInstallerUrl().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackProvisioningParametersResponse)) {
            return false;
        }
        DescribeStackProvisioningParametersResponse other = (DescribeStackProvisioningParametersResponse)((Object)obj);
        if (other.agentInstallerUrl() == null ^ this.agentInstallerUrl() == null) {
            return false;
        }
        if (other.agentInstallerUrl() != null && !other.agentInstallerUrl().equals(this.agentInstallerUrl())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.agentInstallerUrl() != null) {
            sb.append("AgentInstallerUrl: ").append(this.agentInstallerUrl()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String agentInstallerUrl;
        private Map<String, String> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackProvisioningParametersResponse model) {
            this.setAgentInstallerUrl(model.agentInstallerUrl);
            this.setParameters(model.parameters);
        }

        public final String getAgentInstallerUrl() {
            return this.agentInstallerUrl;
        }

        @Override
        public final Builder agentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
            return this;
        }

        public final void setAgentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public DescribeStackProvisioningParametersResponse build() {
            return new DescribeStackProvisioningParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStackProvisioningParametersResponse> {
        public Builder agentInstallerUrl(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

