/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.ElasticIp;
import software.amazon.awssdk.services.opsworks.model.ElasticIpsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticIpsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeElasticIpsResponse> {
    private final List<ElasticIp> elasticIps;

    private DescribeElasticIpsResponse(BuilderImpl builder) {
        this.elasticIps = builder.elasticIps;
    }

    public List<ElasticIp> elasticIps() {
        return this.elasticIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.elasticIps() == null ? 0 : this.elasticIps().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsResponse)) {
            return false;
        }
        DescribeElasticIpsResponse other = (DescribeElasticIpsResponse)((Object)obj);
        if (other.elasticIps() == null ^ this.elasticIps() == null) {
            return false;
        }
        return other.elasticIps() == null || other.elasticIps().equals(this.elasticIps());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.elasticIps() != null) {
            sb.append("ElasticIps: ").append(this.elasticIps()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ElasticIp> elasticIps;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsResponse model) {
            this.setElasticIps(model.elasticIps);
        }

        public final Collection<ElasticIp> getElasticIps() {
            return this.elasticIps;
        }

        @Override
        public final Builder elasticIps(Collection<ElasticIp> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copy(elasticIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticIps(ElasticIp ... elasticIps) {
            this.elasticIps(Arrays.asList(elasticIps));
            return this;
        }

        public final void setElasticIps(Collection<ElasticIp> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copy(elasticIps);
        }

        @SafeVarargs
        public final void setElasticIps(ElasticIp ... elasticIps) {
            this.elasticIps(Arrays.asList(elasticIps));
        }

        public DescribeElasticIpsResponse build() {
            return new DescribeElasticIpsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticIpsResponse> {
        public Builder elasticIps(Collection<ElasticIp> var1);

        public Builder elasticIps(ElasticIp ... var1);
    }
}

