/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.TemporaryCredential;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TemporaryCredentialMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();
    private static final MarshallingInfo<Integer> VALIDFORINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidForInMinutes").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final TemporaryCredentialMarshaller INSTANCE = new TemporaryCredentialMarshaller();

    private TemporaryCredentialMarshaller() {
    }

    public static TemporaryCredentialMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TemporaryCredential temporaryCredential, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)temporaryCredential, (String)"temporaryCredential");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)temporaryCredential.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)temporaryCredential.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)temporaryCredential.validForInMinutes(), VALIDFORINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)temporaryCredential.instanceId(), INSTANCEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

