/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.RaidArray;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RaidArrayMarshaller {
    private static final MarshallingInfo<String> RAIDARRAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidArrayId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<Integer> RAIDLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidLevel").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFDISKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfDisks").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Device").isBinary(false).build();
    private static final MarshallingInfo<String> MOUNTPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountPoint").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").isBinary(false).build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").isBinary(false).build();
    private static final RaidArrayMarshaller INSTANCE = new RaidArrayMarshaller();

    private RaidArrayMarshaller() {
    }

    public static RaidArrayMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RaidArray raidArray, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)raidArray, (String)"raidArray");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)raidArray.raidArrayId(), RAIDARRAYID_BINDING);
            protocolMarshaller.marshall((Object)raidArray.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)raidArray.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)raidArray.raidLevel(), RAIDLEVEL_BINDING);
            protocolMarshaller.marshall((Object)raidArray.numberOfDisks(), NUMBEROFDISKS_BINDING);
            protocolMarshaller.marshall((Object)raidArray.size(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)raidArray.device(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)raidArray.mountPoint(), MOUNTPOINT_BINDING);
            protocolMarshaller.marshall((Object)raidArray.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)raidArray.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)raidArray.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)raidArray.volumeType(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)raidArray.iops(), IOPS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

