/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.EcsCluster;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EcsClusterMarshaller {
    private static final MarshallingInfo<String> ECSCLUSTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EcsClusterArn").isBinary(false).build();
    private static final MarshallingInfo<String> ECSCLUSTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EcsClusterName").isBinary(false).build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> REGISTEREDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegisteredAt").isBinary(false).build();
    private static final EcsClusterMarshaller INSTANCE = new EcsClusterMarshaller();

    private EcsClusterMarshaller() {
    }

    public static EcsClusterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EcsCluster ecsCluster, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ecsCluster, (String)"ecsCluster");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ecsCluster.ecsClusterArn(), ECSCLUSTERARN_BINDING);
            protocolMarshaller.marshall((Object)ecsCluster.ecsClusterName(), ECSCLUSTERNAME_BINDING);
            protocolMarshaller.marshall((Object)ecsCluster.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)ecsCluster.registeredAt(), REGISTEREDAT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

