/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.DescribeInstancesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeInstancesRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> LAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerId").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIds").isBinary(false).build();
    private static final DescribeInstancesRequestModelMarshaller INSTANCE = new DescribeInstancesRequestModelMarshaller();

    private DescribeInstancesRequestModelMarshaller() {
    }

    public static DescribeInstancesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeInstancesRequest describeInstancesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeInstancesRequest), (String)"describeInstancesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeInstancesRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)describeInstancesRequest.layerId(), LAYERID_BINDING);
            protocolMarshaller.marshall(describeInstancesRequest.instanceIds(), INSTANCEIDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

