/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.Command;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CommandMarshaller {
    private static final MarshallingInfo<String> COMMANDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> ACKNOWLEDGEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcknowledgedAt").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLETEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedAt").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Integer> EXITCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExitCode").isBinary(false).build();
    private static final MarshallingInfo<String> LOGURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogUrl").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final CommandMarshaller INSTANCE = new CommandMarshaller();

    private CommandMarshaller() {
    }

    public static CommandMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Command command, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)command, (String)"command");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)command.commandId(), COMMANDID_BINDING);
            protocolMarshaller.marshall((Object)command.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)command.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)command.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)command.acknowledgedAt(), ACKNOWLEDGEDAT_BINDING);
            protocolMarshaller.marshall((Object)command.completedAt(), COMPLETEDAT_BINDING);
            protocolMarshaller.marshall((Object)command.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)command.exitCode(), EXITCODE_BINDING);
            protocolMarshaller.marshall((Object)command.logUrl(), LOGURL_BINDING);
            protocolMarshaller.marshall((Object)command.type(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

