/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.WeeklyAutoScalingSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetTimeBasedAutoScalingRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, SetTimeBasedAutoScalingRequest> {
    private final String instanceId;
    private final WeeklyAutoScalingSchedule autoScalingSchedule;

    private SetTimeBasedAutoScalingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.autoScalingSchedule = builder.autoScalingSchedule;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public WeeklyAutoScalingSchedule autoScalingSchedule() {
        return this.autoScalingSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingSchedule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTimeBasedAutoScalingRequest)) {
            return false;
        }
        SetTimeBasedAutoScalingRequest other = (SetTimeBasedAutoScalingRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.autoScalingSchedule(), other.autoScalingSchedule());
    }

    public String toString() {
        return ToString.builder((String)"SetTimeBasedAutoScalingRequest").add("InstanceId", (Object)this.instanceId()).add("AutoScalingSchedule", (Object)this.autoScalingSchedule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AutoScalingSchedule": {
                return Optional.ofNullable(clazz.cast(this.autoScalingSchedule()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private WeeklyAutoScalingSchedule autoScalingSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTimeBasedAutoScalingRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.autoScalingSchedule(model.autoScalingSchedule);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final WeeklyAutoScalingSchedule.Builder getAutoScalingSchedule() {
            return this.autoScalingSchedule != null ? this.autoScalingSchedule.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingSchedule(WeeklyAutoScalingSchedule autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule;
            return this;
        }

        public final void setAutoScalingSchedule(WeeklyAutoScalingSchedule.BuilderImpl autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule != null ? autoScalingSchedule.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTimeBasedAutoScalingRequest build() {
            return new SetTimeBasedAutoScalingRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, SetTimeBasedAutoScalingRequest> {
        public Builder instanceId(String var1);

        public Builder autoScalingSchedule(WeeklyAutoScalingSchedule var1);

        default public Builder autoScalingSchedule(Consumer<WeeklyAutoScalingSchedule.Builder> autoScalingSchedule) {
            return this.autoScalingSchedule((WeeklyAutoScalingSchedule)((WeeklyAutoScalingSchedule.Builder)WeeklyAutoScalingSchedule.builder().applyMutation(autoScalingSchedule)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

