/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.opsworks.model.AutoScalingThresholds;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetLoadBasedAutoScalingRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, SetLoadBasedAutoScalingRequest> {
    private final String layerId;
    private final Boolean enable;
    private final AutoScalingThresholds upScaling;
    private final AutoScalingThresholds downScaling;

    private SetLoadBasedAutoScalingRequest(BuilderImpl builder) {
        super(builder);
        this.layerId = builder.layerId;
        this.enable = builder.enable;
        this.upScaling = builder.upScaling;
        this.downScaling = builder.downScaling;
    }

    public String layerId() {
        return this.layerId;
    }

    public Boolean enable() {
        return this.enable;
    }

    public AutoScalingThresholds upScaling() {
        return this.upScaling;
    }

    public AutoScalingThresholds downScaling() {
        return this.downScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        hashCode = 31 * hashCode + Objects.hashCode(this.upScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.downScaling());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBasedAutoScalingRequest)) {
            return false;
        }
        SetLoadBasedAutoScalingRequest other = (SetLoadBasedAutoScalingRequest)((Object)obj);
        return Objects.equals(this.layerId(), other.layerId()) && Objects.equals(this.enable(), other.enable()) && Objects.equals(this.upScaling(), other.upScaling()) && Objects.equals(this.downScaling(), other.downScaling());
    }

    public String toString() {
        return ToString.builder((String)"SetLoadBasedAutoScalingRequest").add("LayerId", (Object)this.layerId()).add("Enable", (Object)this.enable()).add("UpScaling", (Object)this.upScaling()).add("DownScaling", (Object)this.downScaling()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerId": {
                return Optional.ofNullable(clazz.cast(this.layerId()));
            }
            case "Enable": {
                return Optional.ofNullable(clazz.cast(this.enable()));
            }
            case "UpScaling": {
                return Optional.ofNullable(clazz.cast(this.upScaling()));
            }
            case "DownScaling": {
                return Optional.ofNullable(clazz.cast(this.downScaling()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String layerId;
        private Boolean enable;
        private AutoScalingThresholds upScaling;
        private AutoScalingThresholds downScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBasedAutoScalingRequest model) {
            super(model);
            this.layerId(model.layerId);
            this.enable(model.enable);
            this.upScaling(model.upScaling);
            this.downScaling(model.downScaling);
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final AutoScalingThresholds.Builder getUpScaling() {
            return this.upScaling != null ? this.upScaling.toBuilder() : null;
        }

        @Override
        public final Builder upScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
            return this;
        }

        public final void setUpScaling(AutoScalingThresholds.BuilderImpl upScaling) {
            this.upScaling = upScaling != null ? upScaling.build() : null;
        }

        public final AutoScalingThresholds.Builder getDownScaling() {
            return this.downScaling != null ? this.downScaling.toBuilder() : null;
        }

        @Override
        public final Builder downScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
            return this;
        }

        public final void setDownScaling(AutoScalingThresholds.BuilderImpl downScaling) {
            this.downScaling = downScaling != null ? downScaling.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLoadBasedAutoScalingRequest build() {
            return new SetLoadBasedAutoScalingRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, SetLoadBasedAutoScalingRequest> {
        public Builder layerId(String var1);

        public Builder enable(Boolean var1);

        public Builder upScaling(AutoScalingThresholds var1);

        default public Builder upScaling(Consumer<AutoScalingThresholds.Builder> upScaling) {
            return this.upScaling((AutoScalingThresholds)((AutoScalingThresholds.Builder)AutoScalingThresholds.builder().applyMutation(upScaling)).build());
        }

        public Builder downScaling(AutoScalingThresholds var1);

        default public Builder downScaling(Consumer<AutoScalingThresholds.Builder> downScaling) {
            return this.downScaling((AutoScalingThresholds)((AutoScalingThresholds.Builder)AutoScalingThresholds.builder().applyMutation(downScaling)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

