/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OperatingSystemConfigurationManager;
import software.amazon.awssdk.services.opsworks.model.OperatingSystemConfigurationManagersCopier;
import software.amazon.awssdk.services.opsworks.transform.OperatingSystemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OperatingSystem
implements StructuredPojo,
ToCopyableBuilder<Builder, OperatingSystem> {
    private final String name;
    private final String id;
    private final String type;
    private final List<OperatingSystemConfigurationManager> configurationManagers;
    private final String reportedName;
    private final String reportedVersion;
    private final Boolean supported;

    private OperatingSystem(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.type = builder.type;
        this.configurationManagers = builder.configurationManagers;
        this.reportedName = builder.reportedName;
        this.reportedVersion = builder.reportedVersion;
        this.supported = builder.supported;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public List<OperatingSystemConfigurationManager> configurationManagers() {
        return this.configurationManagers;
    }

    public String reportedName() {
        return this.reportedName;
    }

    public String reportedVersion() {
        return this.reportedVersion;
    }

    public Boolean supported() {
        return this.supported;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationManagers());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.supported());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperatingSystem)) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.configurationManagers(), other.configurationManagers()) && Objects.equals(this.reportedName(), other.reportedName()) && Objects.equals(this.reportedVersion(), other.reportedVersion()) && Objects.equals(this.supported(), other.supported());
    }

    public String toString() {
        return ToString.builder((String)"OperatingSystem").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Type", (Object)this.type()).add("ConfigurationManagers", this.configurationManagers()).add("ReportedName", (Object)this.reportedName()).add("ReportedVersion", (Object)this.reportedVersion()).add("Supported", (Object)this.supported()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "ConfigurationManagers": {
                return Optional.ofNullable(clazz.cast(this.configurationManagers()));
            }
            case "ReportedName": {
                return Optional.ofNullable(clazz.cast(this.reportedName()));
            }
            case "ReportedVersion": {
                return Optional.ofNullable(clazz.cast(this.reportedVersion()));
            }
            case "Supported": {
                return Optional.ofNullable(clazz.cast(this.supported()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperatingSystemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String type;
        private List<OperatingSystemConfigurationManager> configurationManagers = DefaultSdkAutoConstructList.getInstance();
        private String reportedName;
        private String reportedVersion;
        private Boolean supported;

        private BuilderImpl() {
        }

        private BuilderImpl(OperatingSystem model) {
            this.name(model.name);
            this.id(model.id);
            this.type(model.type);
            this.configurationManagers(model.configurationManagers);
            this.reportedName(model.reportedName);
            this.reportedVersion(model.reportedVersion);
            this.supported(model.supported);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<OperatingSystemConfigurationManager.Builder> getConfigurationManagers() {
            return this.configurationManagers != null ? (Collection)this.configurationManagers.stream().map(OperatingSystemConfigurationManager::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationManagers(Collection<OperatingSystemConfigurationManager> configurationManagers) {
            this.configurationManagers = OperatingSystemConfigurationManagersCopier.copy(configurationManagers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagers(OperatingSystemConfigurationManager ... configurationManagers) {
            this.configurationManagers(Arrays.asList(configurationManagers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagers(Consumer<OperatingSystemConfigurationManager.Builder> ... configurationManagers) {
            this.configurationManagers(Stream.of(configurationManagers).map(c -> (OperatingSystemConfigurationManager)((OperatingSystemConfigurationManager.Builder)OperatingSystemConfigurationManager.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationManagers(Collection<OperatingSystemConfigurationManager.BuilderImpl> configurationManagers) {
            this.configurationManagers = OperatingSystemConfigurationManagersCopier.copyFromBuilder(configurationManagers);
        }

        public final String getReportedName() {
            return this.reportedName;
        }

        @Override
        public final Builder reportedName(String reportedName) {
            this.reportedName = reportedName;
            return this;
        }

        public final void setReportedName(String reportedName) {
            this.reportedName = reportedName;
        }

        public final String getReportedVersion() {
            return this.reportedVersion;
        }

        @Override
        public final Builder reportedVersion(String reportedVersion) {
            this.reportedVersion = reportedVersion;
            return this;
        }

        public final void setReportedVersion(String reportedVersion) {
            this.reportedVersion = reportedVersion;
        }

        public final Boolean getSupported() {
            return this.supported;
        }

        @Override
        public final Builder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        public final void setSupported(Boolean supported) {
            this.supported = supported;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OperatingSystem> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder configurationManagers(Collection<OperatingSystemConfigurationManager> var1);

        public Builder configurationManagers(OperatingSystemConfigurationManager ... var1);

        public Builder configurationManagers(Consumer<OperatingSystemConfigurationManager.Builder> ... var1);

        public Builder reportedName(String var1);

        public Builder reportedVersion(String var1);

        public Builder supported(Boolean var1);
    }
}

