/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRaidArraysRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeRaidArraysRequest> {
    private final String instanceId;
    private final String stackId;
    private final List<String> raidArrayIds;

    private DescribeRaidArraysRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.raidArrayIds = builder.raidArrayIds;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> raidArrayIds() {
        return this.raidArrayIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.raidArrayIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRaidArraysRequest)) {
            return false;
        }
        DescribeRaidArraysRequest other = (DescribeRaidArraysRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.raidArrayIds(), other.raidArrayIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRaidArraysRequest").add("InstanceId", (Object)this.instanceId()).add("StackId", (Object)this.stackId()).add("RaidArrayIds", this.raidArrayIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "RaidArrayIds": {
                return Optional.ofNullable(clazz.cast(this.raidArrayIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String stackId;
        private List<String> raidArrayIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRaidArraysRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.stackId(model.stackId);
            this.raidArrayIds(model.raidArrayIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getRaidArrayIds() {
            return this.raidArrayIds;
        }

        @Override
        public final Builder raidArrayIds(Collection<String> raidArrayIds) {
            this.raidArrayIds = StringsCopier.copy(raidArrayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder raidArrayIds(String ... raidArrayIds) {
            this.raidArrayIds(Arrays.asList(raidArrayIds));
            return this;
        }

        public final void setRaidArrayIds(Collection<String> raidArrayIds) {
            this.raidArrayIds = StringsCopier.copy(raidArrayIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRaidArraysRequest build() {
            return new DescribeRaidArraysRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribeRaidArraysRequest> {
        public Builder instanceId(String var1);

        public Builder stackId(String var1);

        public Builder raidArrayIds(Collection<String> var1);

        public Builder raidArrayIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

