/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.EcsCluster;
import software.amazon.awssdk.services.opsworks.model.EcsClustersCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEcsClustersResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeEcsClustersResponse> {
    private final List<EcsCluster> ecsClusters;
    private final String nextToken;

    private DescribeEcsClustersResponse(BuilderImpl builder) {
        super(builder);
        this.ecsClusters = builder.ecsClusters;
        this.nextToken = builder.nextToken;
    }

    public List<EcsCluster> ecsClusters() {
        return this.ecsClusters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsClusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersResponse)) {
            return false;
        }
        DescribeEcsClustersResponse other = (DescribeEcsClustersResponse)((Object)obj);
        return Objects.equals(this.ecsClusters(), other.ecsClusters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEcsClustersResponse").add("EcsClusters", this.ecsClusters()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EcsClusters": {
                return Optional.ofNullable(clazz.cast(this.ecsClusters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<EcsCluster> ecsClusters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersResponse model) {
            super(model);
            this.ecsClusters(model.ecsClusters);
            this.nextToken(model.nextToken);
        }

        public final Collection<EcsCluster.Builder> getEcsClusters() {
            return this.ecsClusters != null ? (Collection)this.ecsClusters.stream().map(EcsCluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ecsClusters(Collection<EcsCluster> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copy(ecsClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusters(EcsCluster ... ecsClusters) {
            this.ecsClusters(Arrays.asList(ecsClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusters(Consumer<EcsCluster.Builder> ... ecsClusters) {
            this.ecsClusters(Stream.of(ecsClusters).map(c -> (EcsCluster)((EcsCluster.Builder)EcsCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEcsClusters(Collection<EcsCluster.BuilderImpl> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copyFromBuilder(ecsClusters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEcsClustersResponse build() {
            return new DescribeEcsClustersResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeEcsClustersResponse> {
        public Builder ecsClusters(Collection<EcsCluster> var1);

        public Builder ecsClusters(EcsCluster ... var1);

        public Builder ecsClusters(Consumer<EcsCluster.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

