/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.Command;
import software.amazon.awssdk.services.opsworks.model.CommandsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCommandsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeCommandsResponse> {
    private final List<Command> commands;

    private DescribeCommandsResponse(BuilderImpl builder) {
        super(builder);
        this.commands = builder.commands;
    }

    public List<Command> commands() {
        return this.commands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commands());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsResponse)) {
            return false;
        }
        DescribeCommandsResponse other = (DescribeCommandsResponse)((Object)obj);
        return Objects.equals(this.commands(), other.commands());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCommandsResponse").add("Commands", this.commands()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Commands": {
                return Optional.ofNullable(clazz.cast(this.commands()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<Command> commands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsResponse model) {
            super(model);
            this.commands(model.commands);
        }

        public final Collection<Command.Builder> getCommands() {
            return this.commands != null ? (Collection)this.commands.stream().map(Command::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandsCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command ... commands) {
            this.commands(Arrays.asList(commands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Consumer<Command.Builder> ... commands) {
            this.commands(Stream.of(commands).map(c -> (Command)((Command.Builder)Command.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommands(Collection<Command.BuilderImpl> commands) {
            this.commands = CommandsCopier.copyFromBuilder(commands);
        }

        @Override
        public DescribeCommandsResponse build() {
            return new DescribeCommandsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeCommandsResponse> {
        public Builder commands(Collection<Command> var1);

        public Builder commands(Command ... var1);

        public Builder commands(Consumer<Command.Builder> ... var1);
    }
}

