/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.App;
import software.amazon.awssdk.services.opsworks.model.AppsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeAppsResponse> {
    private final List<App> apps;

    private DescribeAppsResponse(BuilderImpl builder) {
        super(builder);
        this.apps = builder.apps;
    }

    public List<App> apps() {
        return this.apps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppsResponse)) {
            return false;
        }
        DescribeAppsResponse other = (DescribeAppsResponse)((Object)obj);
        return Objects.equals(this.apps(), other.apps());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAppsResponse").add("Apps", this.apps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Apps": {
                return Optional.ofNullable(clazz.cast(this.apps()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<App> apps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppsResponse model) {
            super(model);
            this.apps(model.apps);
        }

        public final Collection<App.Builder> getApps() {
            return this.apps != null ? (Collection)this.apps.stream().map(App::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder apps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(App ... apps) {
            this.apps(Arrays.asList(apps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(Consumer<App.Builder> ... apps) {
            this.apps(Stream.of(apps).map(c -> (App)((App.Builder)App.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApps(Collection<App.BuilderImpl> apps) {
            this.apps = AppsCopier.copyFromBuilder(apps);
        }

        @Override
        public DescribeAppsResponse build() {
            return new DescribeAppsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeAppsResponse> {
        public Builder apps(Collection<App> var1);

        public Builder apps(App ... var1);

        public Builder apps(Consumer<App.Builder> ... var1);
    }
}

