/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.Architecture;
import software.amazon.awssdk.services.opsworks.model.AutoScalingType;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMappingsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.RootDeviceType;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, CreateInstanceRequest> {
    private final String stackId;
    private final List<String> layerIds;
    private final String instanceType;
    private final String autoScalingType;
    private final String hostname;
    private final String os;
    private final String amiId;
    private final String sshKeyName;
    private final String availabilityZone;
    private final String virtualizationType;
    private final String subnetId;
    private final String architecture;
    private final String rootDeviceType;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final Boolean installUpdatesOnBoot;
    private final Boolean ebsOptimized;
    private final String agentVersion;
    private final String tenancy;

    private CreateInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.layerIds = builder.layerIds;
        this.instanceType = builder.instanceType;
        this.autoScalingType = builder.autoScalingType;
        this.hostname = builder.hostname;
        this.os = builder.os;
        this.amiId = builder.amiId;
        this.sshKeyName = builder.sshKeyName;
        this.availabilityZone = builder.availabilityZone;
        this.virtualizationType = builder.virtualizationType;
        this.subnetId = builder.subnetId;
        this.architecture = builder.architecture;
        this.rootDeviceType = builder.rootDeviceType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.ebsOptimized = builder.ebsOptimized;
        this.agentVersion = builder.agentVersion;
        this.tenancy = builder.tenancy;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public AutoScalingType autoScalingType() {
        return AutoScalingType.fromValue(this.autoScalingType);
    }

    public String autoScalingTypeAsString() {
        return this.autoScalingType;
    }

    public String hostname() {
        return this.hostname;
    }

    public String os() {
        return this.os;
    }

    public String amiId() {
        return this.amiId;
    }

    public String sshKeyName() {
        return this.sshKeyName;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String virtualizationType() {
        return this.virtualizationType;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public String architectureAsString() {
        return this.architecture;
    }

    public RootDeviceType rootDeviceType() {
        return RootDeviceType.fromValue(this.rootDeviceType);
    }

    public String rootDeviceTypeAsString() {
        return this.rootDeviceType;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public String tenancy() {
        return this.tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.os());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualizationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceRequest)) {
            return false;
        }
        CreateInstanceRequest other = (CreateInstanceRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.layerIds(), other.layerIds()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.autoScalingTypeAsString(), other.autoScalingTypeAsString()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.os(), other.os()) && Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.sshKeyName(), other.sshKeyName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.virtualizationType(), other.virtualizationType()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.architectureAsString(), other.architectureAsString()) && Objects.equals(this.rootDeviceTypeAsString(), other.rootDeviceTypeAsString()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.installUpdatesOnBoot(), other.installUpdatesOnBoot()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.tenancy(), other.tenancy());
    }

    public String toString() {
        return ToString.builder((String)"CreateInstanceRequest").add("StackId", (Object)this.stackId()).add("LayerIds", this.layerIds()).add("InstanceType", (Object)this.instanceType()).add("AutoScalingType", (Object)this.autoScalingTypeAsString()).add("Hostname", (Object)this.hostname()).add("Os", (Object)this.os()).add("AmiId", (Object)this.amiId()).add("SshKeyName", (Object)this.sshKeyName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VirtualizationType", (Object)this.virtualizationType()).add("SubnetId", (Object)this.subnetId()).add("Architecture", (Object)this.architectureAsString()).add("RootDeviceType", (Object)this.rootDeviceTypeAsString()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("InstallUpdatesOnBoot", (Object)this.installUpdatesOnBoot()).add("EbsOptimized", (Object)this.ebsOptimized()).add("AgentVersion", (Object)this.agentVersion()).add("Tenancy", (Object)this.tenancy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "LayerIds": {
                return Optional.ofNullable(clazz.cast(this.layerIds()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "AutoScalingType": {
                return Optional.ofNullable(clazz.cast(this.autoScalingTypeAsString()));
            }
            case "Hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "Os": {
                return Optional.ofNullable(clazz.cast(this.os()));
            }
            case "AmiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "SshKeyName": {
                return Optional.ofNullable(clazz.cast(this.sshKeyName()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VirtualizationType": {
                return Optional.ofNullable(clazz.cast(this.virtualizationType()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
            case "RootDeviceType": {
                return Optional.ofNullable(clazz.cast(this.rootDeviceTypeAsString()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "InstallUpdatesOnBoot": {
                return Optional.ofNullable(clazz.cast(this.installUpdatesOnBoot()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "AgentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private List<String> layerIds = DefaultSdkAutoConstructList.getInstance();
        private String instanceType;
        private String autoScalingType;
        private String hostname;
        private String os;
        private String amiId;
        private String sshKeyName;
        private String availabilityZone;
        private String virtualizationType;
        private String subnetId;
        private String architecture;
        private String rootDeviceType;
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private Boolean installUpdatesOnBoot;
        private Boolean ebsOptimized;
        private String agentVersion;
        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.layerIds(model.layerIds);
            this.instanceType(model.instanceType);
            this.autoScalingType(model.autoScalingType);
            this.hostname(model.hostname);
            this.os(model.os);
            this.amiId(model.amiId);
            this.sshKeyName(model.sshKeyName);
            this.availabilityZone(model.availabilityZone);
            this.virtualizationType(model.virtualizationType);
            this.subnetId(model.subnetId);
            this.architecture(model.architecture);
            this.rootDeviceType(model.rootDeviceType);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.installUpdatesOnBoot(model.installUpdatesOnBoot);
            this.ebsOptimized(model.ebsOptimized);
            this.agentVersion(model.agentVersion);
            this.tenancy(model.tenancy);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAutoScalingType() {
            return this.autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getRootDeviceType() {
            return this.rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceRequest build() {
            return new CreateInstanceRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, CreateInstanceRequest> {
        public Builder stackId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);

        public Builder instanceType(String var1);

        public Builder autoScalingType(String var1);

        public Builder autoScalingType(AutoScalingType var1);

        public Builder hostname(String var1);

        public Builder os(String var1);

        public Builder amiId(String var1);

        public Builder sshKeyName(String var1);

        public Builder availabilityZone(String var1);

        public Builder virtualizationType(String var1);

        public Builder subnetId(String var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder rootDeviceType(String var1);

        public Builder rootDeviceType(RootDeviceType var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder agentVersion(String var1);

        public Builder tenancy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

