/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.EbsBlockDevice;
import software.amazon.awssdk.services.opsworks.transform.BlockDeviceMappingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockDeviceMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, BlockDeviceMapping> {
    private final String deviceName;
    private final String noDevice;
    private final String virtualName;
    private final EbsBlockDevice ebs;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String noDevice() {
        return this.noDevice;
    }

    public String virtualName() {
        return this.virtualName;
    }

    public EbsBlockDevice ebs() {
        return this.ebs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.noDevice(), other.noDevice()) && Objects.equals(this.virtualName(), other.virtualName()) && Objects.equals(this.ebs(), other.ebs());
    }

    public String toString() {
        return ToString.builder((String)"BlockDeviceMapping").add("DeviceName", (Object)this.deviceName()).add("NoDevice", (Object)this.noDevice()).add("VirtualName", (Object)this.virtualName()).add("Ebs", (Object)this.ebs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "NoDevice": {
                return Optional.ofNullable(clazz.cast(this.noDevice()));
            }
            case "VirtualName": {
                return Optional.ofNullable(clazz.cast(this.virtualName()));
            }
            case "Ebs": {
                return Optional.ofNullable(clazz.cast(this.ebs()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlockDeviceMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private String noDevice;
        private String virtualName;
        private EbsBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            this.deviceName(model.deviceName);
            this.noDevice(model.noDevice);
            this.virtualName(model.virtualName);
            this.ebs(model.ebs);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getNoDevice() {
            return this.noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final EbsBlockDevice.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlockDeviceMapping> {
        public Builder deviceName(String var1);

        public Builder noDevice(String var1);

        public Builder virtualName(String var1);

        public Builder ebs(EbsBlockDevice var1);

        default public Builder ebs(Consumer<EbsBlockDevice.Builder> ebs) {
            return this.ebs((EbsBlockDevice)((EbsBlockDevice.Builder)EbsBlockDevice.builder().applyMutation(ebs)).build());
        }
    }
}

