/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.ShutdownEventConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ShutdownEventConfigurationMarshaller {
    private static final MarshallingInfo<Integer> EXECUTIONTIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionTimeout").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DELAYUNTILELBCONNECTIONSDRAINED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DelayUntilElbConnectionsDrained").isBinary(false).build();
    private static final ShutdownEventConfigurationMarshaller INSTANCE = new ShutdownEventConfigurationMarshaller();

    private ShutdownEventConfigurationMarshaller() {
    }

    public static ShutdownEventConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ShutdownEventConfiguration shutdownEventConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)shutdownEventConfiguration, (String)"shutdownEventConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)shutdownEventConfiguration.executionTimeout(), EXECUTIONTIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)shutdownEventConfiguration.delayUntilElbConnectionsDrained(), DELAYUNTILELBCONNECTIONSDRAINED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

