/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.ServiceError;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceErrorMarshaller {
    private static final MarshallingInfo<String> SERVICEERRORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceErrorId").isBinary(false).build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final ServiceErrorMarshaller INSTANCE = new ServiceErrorMarshaller();

    private ServiceErrorMarshaller() {
    }

    public static ServiceErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServiceError serviceError, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serviceError, (String)"serviceError");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serviceError.serviceErrorId(), SERVICEERRORID_BINDING);
            protocolMarshaller.marshall((Object)serviceError.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)serviceError.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)serviceError.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)serviceError.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)serviceError.createdAt(), CREATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

