/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.InstanceIdentity;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterInstanceRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, RegisterInstanceRequest> {
    private final String stackId;
    private final String hostname;
    private final String publicIp;
    private final String privateIp;
    private final String rsaPublicKey;
    private final String rsaPublicKeyFingerprint;
    private final InstanceIdentity instanceIdentity;

    private RegisterInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.hostname = builder.hostname;
        this.publicIp = builder.publicIp;
        this.privateIp = builder.privateIp;
        this.rsaPublicKey = builder.rsaPublicKey;
        this.rsaPublicKeyFingerprint = builder.rsaPublicKeyFingerprint;
        this.instanceIdentity = builder.instanceIdentity;
    }

    public String stackId() {
        return this.stackId;
    }

    public String hostname() {
        return this.hostname;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String privateIp() {
        return this.privateIp;
    }

    public String rsaPublicKey() {
        return this.rsaPublicKey;
    }

    public String rsaPublicKeyFingerprint() {
        return this.rsaPublicKeyFingerprint;
    }

    public InstanceIdentity instanceIdentity() {
        return this.instanceIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.rsaPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rsaPublicKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIdentity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceRequest)) {
            return false;
        }
        RegisterInstanceRequest other = (RegisterInstanceRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.privateIp(), other.privateIp()) && Objects.equals(this.rsaPublicKey(), other.rsaPublicKey()) && Objects.equals(this.rsaPublicKeyFingerprint(), other.rsaPublicKeyFingerprint()) && Objects.equals(this.instanceIdentity(), other.instanceIdentity());
    }

    public String toString() {
        return ToString.builder((String)"RegisterInstanceRequest").add("StackId", (Object)this.stackId()).add("Hostname", (Object)this.hostname()).add("PublicIp", (Object)this.publicIp()).add("PrivateIp", (Object)this.privateIp()).add("RsaPublicKey", (Object)this.rsaPublicKey()).add("RsaPublicKeyFingerprint", (Object)this.rsaPublicKeyFingerprint()).add("InstanceIdentity", (Object)this.instanceIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "Hostname": {
                return Optional.of(clazz.cast(this.hostname()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
            case "PrivateIp": {
                return Optional.of(clazz.cast(this.privateIp()));
            }
            case "RsaPublicKey": {
                return Optional.of(clazz.cast(this.rsaPublicKey()));
            }
            case "RsaPublicKeyFingerprint": {
                return Optional.of(clazz.cast(this.rsaPublicKeyFingerprint()));
            }
            case "InstanceIdentity": {
                return Optional.of(clazz.cast(this.instanceIdentity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String hostname;
        private String publicIp;
        private String privateIp;
        private String rsaPublicKey;
        private String rsaPublicKeyFingerprint;
        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.hostname(model.hostname);
            this.publicIp(model.publicIp);
            this.privateIp(model.privateIp);
            this.rsaPublicKey(model.rsaPublicKey);
            this.rsaPublicKeyFingerprint(model.rsaPublicKeyFingerprint);
            this.instanceIdentity(model.instanceIdentity);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getRsaPublicKey() {
            return this.rsaPublicKey;
        }

        @Override
        public final Builder rsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
            return this;
        }

        public final void setRsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
        }

        public final String getRsaPublicKeyFingerprint() {
            return this.rsaPublicKeyFingerprint;
        }

        @Override
        public final Builder rsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
            return this;
        }

        public final void setRsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
        }

        public final InstanceIdentity.Builder getInstanceIdentity() {
            return this.instanceIdentity != null ? this.instanceIdentity.toBuilder() : null;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        public final void setInstanceIdentity(InstanceIdentity.BuilderImpl instanceIdentity) {
            this.instanceIdentity = instanceIdentity != null ? instanceIdentity.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterInstanceRequest build() {
            return new RegisterInstanceRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, RegisterInstanceRequest> {
        public Builder stackId(String var1);

        public Builder hostname(String var1);

        public Builder publicIp(String var1);

        public Builder privateIp(String var1);

        public Builder rsaPublicKey(String var1);

        public Builder rsaPublicKeyFingerprint(String var1);

        public Builder instanceIdentity(InstanceIdentity var1);

        default public Builder instanceIdentity(Consumer<InstanceIdentity.Builder> instanceIdentity) {
            return this.instanceIdentity((InstanceIdentity)((InstanceIdentity.Builder)InstanceIdentity.builder().apply(instanceIdentity)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

