/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.opsworks.model.ElasticIp;
import software.amazon.awssdk.services.opsworks.model.ElasticIpsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticIpsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeElasticIpsResponse> {
    private final List<ElasticIp> elasticIps;

    private DescribeElasticIpsResponse(BuilderImpl builder) {
        super(builder);
        this.elasticIps = builder.elasticIps;
    }

    public List<ElasticIp> elasticIps() {
        return this.elasticIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsResponse)) {
            return false;
        }
        DescribeElasticIpsResponse other = (DescribeElasticIpsResponse)((Object)obj);
        return Objects.equals(this.elasticIps(), other.elasticIps());
    }

    public String toString() {
        return ToString.builder((String)"DescribeElasticIpsResponse").add("ElasticIps", this.elasticIps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticIps": {
                return Optional.of(clazz.cast(this.elasticIps()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<ElasticIp> elasticIps;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsResponse model) {
            super(model);
            this.elasticIps(model.elasticIps);
        }

        public final Collection<ElasticIp.Builder> getElasticIps() {
            return this.elasticIps != null ? (Collection)this.elasticIps.stream().map(ElasticIp::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticIps(Collection<ElasticIp> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copy(elasticIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticIps(ElasticIp ... elasticIps) {
            this.elasticIps(Arrays.asList(elasticIps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticIps(Consumer<ElasticIp.Builder> ... elasticIps) {
            this.elasticIps(Stream.of(elasticIps).map(c -> (ElasticIp)((ElasticIp.Builder)ElasticIp.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticIps(Collection<ElasticIp.BuilderImpl> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copyFromBuilder(elasticIps);
        }

        @Override
        public DescribeElasticIpsResponse build() {
            return new DescribeElasticIpsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeElasticIpsResponse> {
        public Builder elasticIps(Collection<ElasticIp> var1);

        public Builder elasticIps(ElasticIp ... var1);

        public Builder elasticIps(Consumer<ElasticIp.Builder> ... var1);
    }
}

