/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.UserProfile;
import software.amazon.awssdk.services.opsworks.model.UserProfilesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeUserProfilesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeUserProfilesResponse> {
    private final List<UserProfile> userProfiles;

    private DescribeUserProfilesResponse(BuilderImpl builder) {
        this.userProfiles = builder.userProfiles;
    }

    public List<UserProfile> userProfiles() {
        return this.userProfiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userProfiles() == null ? 0 : this.userProfiles().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesResponse)) {
            return false;
        }
        DescribeUserProfilesResponse other = (DescribeUserProfilesResponse)((Object)obj);
        if (other.userProfiles() == null ^ this.userProfiles() == null) {
            return false;
        }
        return other.userProfiles() == null || other.userProfiles().equals(this.userProfiles());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userProfiles() != null) {
            sb.append("UserProfiles: ").append(this.userProfiles()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<UserProfile> userProfiles = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesResponse model) {
            this.setUserProfiles(model.userProfiles);
        }

        public final Collection<UserProfile> getUserProfiles() {
            return this.userProfiles;
        }

        @Override
        public final Builder userProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfile ... userProfiles) {
            if (this.userProfiles == null) {
                this.userProfiles = new SdkInternalList(userProfiles.length);
            }
            for (UserProfile e : userProfiles) {
                this.userProfiles.add(e);
            }
            return this;
        }

        public final void setUserProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
        }

        @SafeVarargs
        public final void setUserProfiles(UserProfile ... userProfiles) {
            if (this.userProfiles == null) {
                this.userProfiles = new SdkInternalList(userProfiles.length);
            }
            for (UserProfile e : userProfiles) {
                this.userProfiles.add(e);
            }
        }

        public DescribeUserProfilesResponse build() {
            return new DescribeUserProfilesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeUserProfilesResponse> {
        public Builder userProfiles(Collection<UserProfile> var1);

        public Builder userProfiles(UserProfile ... var1);
    }
}

