/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServiceErrorsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeServiceErrorsRequest> {
    private final String stackId;
    private final String instanceId;
    private final List<String> serviceErrorIds;

    private DescribeServiceErrorsRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.instanceId = builder.instanceId;
        this.serviceErrorIds = builder.serviceErrorIds;
    }

    public String stackId() {
        return this.stackId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<String> serviceErrorIds() {
        return this.serviceErrorIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.serviceErrorIds() == null ? 0 : this.serviceErrorIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsRequest)) {
            return false;
        }
        DescribeServiceErrorsRequest other = (DescribeServiceErrorsRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.serviceErrorIds() == null ^ this.serviceErrorIds() == null) {
            return false;
        }
        return other.serviceErrorIds() == null || other.serviceErrorIds().equals(this.serviceErrorIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.serviceErrorIds() != null) {
            sb.append("ServiceErrorIds: ").append(this.serviceErrorIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String instanceId;
        private List<String> serviceErrorIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsRequest model) {
            this.setStackId(model.stackId);
            this.setInstanceId(model.instanceId);
            this.setServiceErrorIds(model.serviceErrorIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getServiceErrorIds() {
            return this.serviceErrorIds;
        }

        @Override
        public final Builder serviceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrorIds(String ... serviceErrorIds) {
            if (this.serviceErrorIds == null) {
                this.serviceErrorIds = new SdkInternalList(serviceErrorIds.length);
            }
            for (String e : serviceErrorIds) {
                this.serviceErrorIds.add(e);
            }
            return this;
        }

        public final void setServiceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
        }

        @SafeVarargs
        public final void setServiceErrorIds(String ... serviceErrorIds) {
            if (this.serviceErrorIds == null) {
                this.serviceErrorIds = new SdkInternalList(serviceErrorIds.length);
            }
            for (String e : serviceErrorIds) {
                this.serviceErrorIds.add(e);
            }
        }

        public DescribeServiceErrorsRequest build() {
            return new DescribeServiceErrorsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeServiceErrorsRequest> {
        public Builder stackId(String var1);

        public Builder instanceId(String var1);

        public Builder serviceErrorIds(Collection<String> var1);

        public Builder serviceErrorIds(String ... var1);
    }
}

