/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRdsDbInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeRdsDbInstancesRequest> {
    private final String stackId;
    private final List<String> rdsDbInstanceArns;

    private DescribeRdsDbInstancesRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.rdsDbInstanceArns = builder.rdsDbInstanceArns;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> rdsDbInstanceArns() {
        return this.rdsDbInstanceArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.rdsDbInstanceArns() == null ? 0 : this.rdsDbInstanceArns().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesRequest)) {
            return false;
        }
        DescribeRdsDbInstancesRequest other = (DescribeRdsDbInstancesRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.rdsDbInstanceArns() == null ^ this.rdsDbInstanceArns() == null) {
            return false;
        }
        return other.rdsDbInstanceArns() == null || other.rdsDbInstanceArns().equals(this.rdsDbInstanceArns());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.rdsDbInstanceArns() != null) {
            sb.append("RdsDbInstanceArns: ").append(this.rdsDbInstanceArns()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private List<String> rdsDbInstanceArns = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesRequest model) {
            this.setStackId(model.stackId);
            this.setRdsDbInstanceArns(model.rdsDbInstanceArns);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getRdsDbInstanceArns() {
            return this.rdsDbInstanceArns;
        }

        @Override
        public final Builder rdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstanceArns(String ... rdsDbInstanceArns) {
            if (this.rdsDbInstanceArns == null) {
                this.rdsDbInstanceArns = new SdkInternalList(rdsDbInstanceArns.length);
            }
            for (String e : rdsDbInstanceArns) {
                this.rdsDbInstanceArns.add(e);
            }
            return this;
        }

        public final void setRdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
        }

        @SafeVarargs
        public final void setRdsDbInstanceArns(String ... rdsDbInstanceArns) {
            if (this.rdsDbInstanceArns == null) {
                this.rdsDbInstanceArns = new SdkInternalList(rdsDbInstanceArns.length);
            }
            for (String e : rdsDbInstanceArns) {
                this.rdsDbInstanceArns.add(e);
            }
        }

        public DescribeRdsDbInstancesRequest build() {
            return new DescribeRdsDbInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRdsDbInstancesRequest> {
        public Builder stackId(String var1);

        public Builder rdsDbInstanceArns(Collection<String> var1);

        public Builder rdsDbInstanceArns(String ... var1);
    }
}

