/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamlConfigOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamlConfigOptions> {
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadata").getter(SamlConfigOptions.getter(SamlConfigOptions::metadata)).setter(SamlConfigOptions.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAttribute").getter(SamlConfigOptions.getter(SamlConfigOptions::userAttribute)).setter(SamlConfigOptions.setter(Builder::userAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()}).build();
    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupAttribute").getter(SamlConfigOptions.getter(SamlConfigOptions::groupAttribute)).setter(SamlConfigOptions.setter(Builder::groupAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAttribute").build()}).build();
    private static final SdkField<String> OPEN_SEARCH_SERVERLESS_ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("openSearchServerlessEntityId").getter(SamlConfigOptions.getter(SamlConfigOptions::openSearchServerlessEntityId)).setter(SamlConfigOptions.setter(Builder::openSearchServerlessEntityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearchServerlessEntityId").build()}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sessionTimeout").getter(SamlConfigOptions.getter(SamlConfigOptions::sessionTimeout)).setter(SamlConfigOptions.setter(Builder::sessionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, USER_ATTRIBUTE_FIELD, GROUP_ATTRIBUTE_FIELD, OPEN_SEARCH_SERVERLESS_ENTITY_ID_FIELD, SESSION_TIMEOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SamlConfigOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metadata;
    private final String userAttribute;
    private final String groupAttribute;
    private final String openSearchServerlessEntityId;
    private final Integer sessionTimeout;

    private SamlConfigOptions(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.userAttribute = builder.userAttribute;
        this.groupAttribute = builder.groupAttribute;
        this.openSearchServerlessEntityId = builder.openSearchServerlessEntityId;
        this.sessionTimeout = builder.sessionTimeout;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final String userAttribute() {
        return this.userAttribute;
    }

    public final String groupAttribute() {
        return this.groupAttribute;
    }

    public final String openSearchServerlessEntityId() {
        return this.openSearchServerlessEntityId;
    }

    public final Integer sessionTimeout() {
        return this.sessionTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.openSearchServerlessEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlConfigOptions)) {
            return false;
        }
        SamlConfigOptions other = (SamlConfigOptions)obj;
        return Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.userAttribute(), other.userAttribute()) && Objects.equals(this.groupAttribute(), other.groupAttribute()) && Objects.equals(this.openSearchServerlessEntityId(), other.openSearchServerlessEntityId()) && Objects.equals(this.sessionTimeout(), other.sessionTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"SamlConfigOptions").add("Metadata", (Object)this.metadata()).add("UserAttribute", (Object)this.userAttribute()).add("GroupAttribute", (Object)this.groupAttribute()).add("OpenSearchServerlessEntityId", (Object)this.openSearchServerlessEntityId()).add("SessionTimeout", (Object)this.sessionTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "userAttribute": {
                return Optional.ofNullable(clazz.cast(this.userAttribute()));
            }
            case "groupAttribute": {
                return Optional.ofNullable(clazz.cast(this.groupAttribute()));
            }
            case "openSearchServerlessEntityId": {
                return Optional.ofNullable(clazz.cast(this.openSearchServerlessEntityId()));
            }
            case "sessionTimeout": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metadata", METADATA_FIELD);
        map.put("userAttribute", USER_ATTRIBUTE_FIELD);
        map.put("groupAttribute", GROUP_ATTRIBUTE_FIELD);
        map.put("openSearchServerlessEntityId", OPEN_SEARCH_SERVERLESS_ENTITY_ID_FIELD);
        map.put("sessionTimeout", SESSION_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamlConfigOptions, T> g) {
        return obj -> g.apply((SamlConfigOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metadata;
        private String userAttribute;
        private String groupAttribute;
        private String openSearchServerlessEntityId;
        private Integer sessionTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlConfigOptions model) {
            this.metadata(model.metadata);
            this.userAttribute(model.userAttribute);
            this.groupAttribute(model.groupAttribute);
            this.openSearchServerlessEntityId(model.openSearchServerlessEntityId);
            this.sessionTimeout(model.sessionTimeout);
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getUserAttribute() {
            return this.userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        public final String getGroupAttribute() {
            return this.groupAttribute;
        }

        public final void setGroupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
        }

        @Override
        public final Builder groupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
            return this;
        }

        public final String getOpenSearchServerlessEntityId() {
            return this.openSearchServerlessEntityId;
        }

        public final void setOpenSearchServerlessEntityId(String openSearchServerlessEntityId) {
            this.openSearchServerlessEntityId = openSearchServerlessEntityId;
        }

        @Override
        public final Builder openSearchServerlessEntityId(String openSearchServerlessEntityId) {
            this.openSearchServerlessEntityId = openSearchServerlessEntityId;
            return this;
        }

        public final Integer getSessionTimeout() {
            return this.sessionTimeout;
        }

        public final void setSessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public SamlConfigOptions build() {
            return new SamlConfigOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamlConfigOptions> {
        public Builder metadata(String var1);

        public Builder userAttribute(String var1);

        public Builder groupAttribute(String var1);

        public Builder openSearchServerlessEntityId(String var1);

        public Builder sessionTimeout(Integer var1);
    }
}

