/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClient;
import software.amazon.awssdk.services.opensearchserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse;

public class ListAccessPoliciesIterable
implements SdkIterable<ListAccessPoliciesResponse> {
    private final OpenSearchServerlessClient client;
    private final ListAccessPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessPoliciesIterable(OpenSearchServerlessClient client, ListAccessPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessPoliciesResponseFetcher();
    }

    public Iterator<ListAccessPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccessPoliciesResponseFetcher
    implements SyncPageFetcher<ListAccessPoliciesResponse> {
        private ListAccessPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessPoliciesResponse nextPage(ListAccessPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPoliciesIterable.this.client.listAccessPolicies(ListAccessPoliciesIterable.this.firstRequest);
            }
            return ListAccessPoliciesIterable.this.client.listAccessPolicies((ListAccessPoliciesRequest)((Object)ListAccessPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

