/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPoliciesStatsResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<GetPoliciesStatsResponse.Builder, GetPoliciesStatsResponse> {
    private static final SdkField<AccessPolicyStats> ACCESS_POLICY_STATS_FIELD = SdkField
            .<AccessPolicyStats> builder(MarshallingType.SDK_POJO).memberName("AccessPolicyStats")
            .getter(getter(GetPoliciesStatsResponse::accessPolicyStats)).setter(setter(Builder::accessPolicyStats))
            .constructor(AccessPolicyStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicyStats").build()).build();

    private static final SdkField<SecurityConfigStats> SECURITY_CONFIG_STATS_FIELD = SdkField
            .<SecurityConfigStats> builder(MarshallingType.SDK_POJO).memberName("SecurityConfigStats")
            .getter(getter(GetPoliciesStatsResponse::securityConfigStats)).setter(setter(Builder::securityConfigStats))
            .constructor(SecurityConfigStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfigStats").build())
            .build();

    private static final SdkField<SecurityPolicyStats> SECURITY_POLICY_STATS_FIELD = SdkField
            .<SecurityPolicyStats> builder(MarshallingType.SDK_POJO).memberName("SecurityPolicyStats")
            .getter(getter(GetPoliciesStatsResponse::securityPolicyStats)).setter(setter(Builder::securityPolicyStats))
            .constructor(SecurityPolicyStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyStats").build())
            .build();

    private static final SdkField<Long> TOTAL_POLICY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalPolicyCount").getter(getter(GetPoliciesStatsResponse::totalPolicyCount))
            .setter(setter(Builder::totalPolicyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPolicyCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_STATS_FIELD,
            SECURITY_CONFIG_STATS_FIELD, SECURITY_POLICY_STATS_FIELD, TOTAL_POLICY_COUNT_FIELD));

    private final AccessPolicyStats accessPolicyStats;

    private final SecurityConfigStats securityConfigStats;

    private final SecurityPolicyStats securityPolicyStats;

    private final Long totalPolicyCount;

    private GetPoliciesStatsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicyStats = builder.accessPolicyStats;
        this.securityConfigStats = builder.securityConfigStats;
        this.securityPolicyStats = builder.securityPolicyStats;
        this.totalPolicyCount = builder.totalPolicyCount;
    }

    /**
     * <p>
     * Information about the data access policies in your account.
     * </p>
     * 
     * @return Information about the data access policies in your account.
     */
    public final AccessPolicyStats accessPolicyStats() {
        return accessPolicyStats;
    }

    /**
     * <p>
     * Information about the security configurations in your account.
     * </p>
     * 
     * @return Information about the security configurations in your account.
     */
    public final SecurityConfigStats securityConfigStats() {
        return securityConfigStats;
    }

    /**
     * <p>
     * Information about the security policies in your account.
     * </p>
     * 
     * @return Information about the security policies in your account.
     */
    public final SecurityPolicyStats securityPolicyStats() {
        return securityPolicyStats;
    }

    /**
     * <p>
     * The total number of OpenSearch Serverless security policies and configurations in your account.
     * </p>
     * 
     * @return The total number of OpenSearch Serverless security policies and configurations in your account.
     */
    public final Long totalPolicyCount() {
        return totalPolicyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyStats());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfigStats());
        hashCode = 31 * hashCode + Objects.hashCode(securityPolicyStats());
        hashCode = 31 * hashCode + Objects.hashCode(totalPolicyCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPoliciesStatsResponse)) {
            return false;
        }
        GetPoliciesStatsResponse other = (GetPoliciesStatsResponse) obj;
        return Objects.equals(accessPolicyStats(), other.accessPolicyStats())
                && Objects.equals(securityConfigStats(), other.securityConfigStats())
                && Objects.equals(securityPolicyStats(), other.securityPolicyStats())
                && Objects.equals(totalPolicyCount(), other.totalPolicyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPoliciesStatsResponse").add("AccessPolicyStats", accessPolicyStats())
                .add("SecurityConfigStats", securityConfigStats()).add("SecurityPolicyStats", securityPolicyStats())
                .add("TotalPolicyCount", totalPolicyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPolicyStats":
            return Optional.ofNullable(clazz.cast(accessPolicyStats()));
        case "SecurityConfigStats":
            return Optional.ofNullable(clazz.cast(securityConfigStats()));
        case "SecurityPolicyStats":
            return Optional.ofNullable(clazz.cast(securityPolicyStats()));
        case "TotalPolicyCount":
            return Optional.ofNullable(clazz.cast(totalPolicyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPoliciesStatsResponse, T> g) {
        return obj -> g.apply((GetPoliciesStatsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPoliciesStatsResponse> {
        /**
         * <p>
         * Information about the data access policies in your account.
         * </p>
         * 
         * @param accessPolicyStats
         *        Information about the data access policies in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyStats(AccessPolicyStats accessPolicyStats);

        /**
         * <p>
         * Information about the data access policies in your account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessPolicyStats.Builder} avoiding the
         * need to create one manually via {@link AccessPolicyStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessPolicyStats.Builder#build()} is called immediately and its
         * result is passed to {@link #accessPolicyStats(AccessPolicyStats)}.
         * 
         * @param accessPolicyStats
         *        a consumer that will call methods on {@link AccessPolicyStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicyStats(AccessPolicyStats)
         */
        default Builder accessPolicyStats(Consumer<AccessPolicyStats.Builder> accessPolicyStats) {
            return accessPolicyStats(AccessPolicyStats.builder().applyMutation(accessPolicyStats).build());
        }

        /**
         * <p>
         * Information about the security configurations in your account.
         * </p>
         * 
         * @param securityConfigStats
         *        Information about the security configurations in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfigStats(SecurityConfigStats securityConfigStats);

        /**
         * <p>
         * Information about the security configurations in your account.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityConfigStats.Builder} avoiding the
         * need to create one manually via {@link SecurityConfigStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityConfigStats.Builder#build()} is called immediately and
         * its result is passed to {@link #securityConfigStats(SecurityConfigStats)}.
         * 
         * @param securityConfigStats
         *        a consumer that will call methods on {@link SecurityConfigStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfigStats(SecurityConfigStats)
         */
        default Builder securityConfigStats(Consumer<SecurityConfigStats.Builder> securityConfigStats) {
            return securityConfigStats(SecurityConfigStats.builder().applyMutation(securityConfigStats).build());
        }

        /**
         * <p>
         * Information about the security policies in your account.
         * </p>
         * 
         * @param securityPolicyStats
         *        Information about the security policies in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityPolicyStats(SecurityPolicyStats securityPolicyStats);

        /**
         * <p>
         * Information about the security policies in your account.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityPolicyStats.Builder} avoiding the
         * need to create one manually via {@link SecurityPolicyStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityPolicyStats.Builder#build()} is called immediately and
         * its result is passed to {@link #securityPolicyStats(SecurityPolicyStats)}.
         * 
         * @param securityPolicyStats
         *        a consumer that will call methods on {@link SecurityPolicyStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityPolicyStats(SecurityPolicyStats)
         */
        default Builder securityPolicyStats(Consumer<SecurityPolicyStats.Builder> securityPolicyStats) {
            return securityPolicyStats(SecurityPolicyStats.builder().applyMutation(securityPolicyStats).build());
        }

        /**
         * <p>
         * The total number of OpenSearch Serverless security policies and configurations in your account.
         * </p>
         * 
         * @param totalPolicyCount
         *        The total number of OpenSearch Serverless security policies and configurations in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalPolicyCount(Long totalPolicyCount);
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private AccessPolicyStats accessPolicyStats;

        private SecurityConfigStats securityConfigStats;

        private SecurityPolicyStats securityPolicyStats;

        private Long totalPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPoliciesStatsResponse model) {
            super(model);
            accessPolicyStats(model.accessPolicyStats);
            securityConfigStats(model.securityConfigStats);
            securityPolicyStats(model.securityPolicyStats);
            totalPolicyCount(model.totalPolicyCount);
        }

        public final AccessPolicyStats.Builder getAccessPolicyStats() {
            return accessPolicyStats != null ? accessPolicyStats.toBuilder() : null;
        }

        public final void setAccessPolicyStats(AccessPolicyStats.BuilderImpl accessPolicyStats) {
            this.accessPolicyStats = accessPolicyStats != null ? accessPolicyStats.build() : null;
        }

        @Override
        public final Builder accessPolicyStats(AccessPolicyStats accessPolicyStats) {
            this.accessPolicyStats = accessPolicyStats;
            return this;
        }

        public final SecurityConfigStats.Builder getSecurityConfigStats() {
            return securityConfigStats != null ? securityConfigStats.toBuilder() : null;
        }

        public final void setSecurityConfigStats(SecurityConfigStats.BuilderImpl securityConfigStats) {
            this.securityConfigStats = securityConfigStats != null ? securityConfigStats.build() : null;
        }

        @Override
        public final Builder securityConfigStats(SecurityConfigStats securityConfigStats) {
            this.securityConfigStats = securityConfigStats;
            return this;
        }

        public final SecurityPolicyStats.Builder getSecurityPolicyStats() {
            return securityPolicyStats != null ? securityPolicyStats.toBuilder() : null;
        }

        public final void setSecurityPolicyStats(SecurityPolicyStats.BuilderImpl securityPolicyStats) {
            this.securityPolicyStats = securityPolicyStats != null ? securityPolicyStats.build() : null;
        }

        @Override
        public final Builder securityPolicyStats(SecurityPolicyStats securityPolicyStats) {
            this.securityPolicyStats = securityPolicyStats;
            return this;
        }

        public final Long getTotalPolicyCount() {
            return totalPolicyCount;
        }

        public final void setTotalPolicyCount(Long totalPolicyCount) {
            this.totalPolicyCount = totalPolicyCount;
        }

        @Override
        public final Builder totalPolicyCount(Long totalPolicyCount) {
            this.totalPolicyCount = totalPolicyCount;
            return this;
        }

        @Override
        public GetPoliciesStatsResponse build() {
            return new GetPoliciesStatsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
