/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessAsyncClient;
import software.amazon.awssdk.services.opensearchserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse;

public class ListVpcEndpointsPublisher
implements SdkPublisher<ListVpcEndpointsResponse> {
    private final OpenSearchServerlessAsyncClient client;
    private final ListVpcEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVpcEndpointsPublisher(OpenSearchServerlessAsyncClient client, ListVpcEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVpcEndpointsPublisher(OpenSearchServerlessAsyncClient client, ListVpcEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVpcEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVpcEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVpcEndpointsResponseFetcher
    implements AsyncPageFetcher<ListVpcEndpointsResponse> {
        private ListVpcEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVpcEndpointsResponse> nextPage(ListVpcEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcEndpointsPublisher.this.client.listVpcEndpoints(ListVpcEndpointsPublisher.this.firstRequest);
            }
            return ListVpcEndpointsPublisher.this.client.listVpcEndpoints((ListVpcEndpointsRequest)((Object)ListVpcEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

