/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.VersionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompatibleVersionsMap
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompatibleVersionsMap> {
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceVersion").getter(CompatibleVersionsMap.getter(CompatibleVersionsMap::sourceVersion)).setter(CompatibleVersionsMap.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVersion").build()}).build();
    private static final SdkField<List<String>> TARGET_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetVersions").getter(CompatibleVersionsMap.getter(CompatibleVersionsMap::targetVersions)).setter(CompatibleVersionsMap.setter(Builder::targetVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VERSION_FIELD, TARGET_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompatibleVersionsMap.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceVersion;
    private final List<String> targetVersions;

    private CompatibleVersionsMap(BuilderImpl builder) {
        this.sourceVersion = builder.sourceVersion;
        this.targetVersions = builder.targetVersions;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final boolean hasTargetVersions() {
        return this.targetVersions != null && !(this.targetVersions instanceof SdkAutoConstructList);
    }

    public final List<String> targetVersions() {
        return this.targetVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetVersions() ? this.targetVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleVersionsMap)) {
            return false;
        }
        CompatibleVersionsMap other = (CompatibleVersionsMap)obj;
        return Objects.equals(this.sourceVersion(), other.sourceVersion()) && this.hasTargetVersions() == other.hasTargetVersions() && Objects.equals(this.targetVersions(), other.targetVersions());
    }

    public final String toString() {
        return ToString.builder((String)"CompatibleVersionsMap").add("SourceVersion", (Object)this.sourceVersion()).add("TargetVersions", this.hasTargetVersions() ? this.targetVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "TargetVersions": {
                return Optional.ofNullable(clazz.cast(this.targetVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceVersion", SOURCE_VERSION_FIELD);
        map.put("TargetVersions", TARGET_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompatibleVersionsMap, T> g) {
        return obj -> g.apply((CompatibleVersionsMap)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceVersion;
        private List<String> targetVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibleVersionsMap model) {
            this.sourceVersion(model.sourceVersion);
            this.targetVersions(model.targetVersions);
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final Collection<String> getTargetVersions() {
            if (this.targetVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetVersions;
        }

        public final void setTargetVersions(Collection<String> targetVersions) {
            this.targetVersions = VersionListCopier.copy(targetVersions);
        }

        @Override
        public final Builder targetVersions(Collection<String> targetVersions) {
            this.targetVersions = VersionListCopier.copy(targetVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetVersions(String ... targetVersions) {
            this.targetVersions(Arrays.asList(targetVersions));
            return this;
        }

        public CompatibleVersionsMap build() {
            return new CompatibleVersionsMap(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompatibleVersionsMap> {
        public Builder sourceVersion(String var1);

        public Builder targetVersions(Collection<String> var1);

        public Builder targetVersions(String ... var1);
    }
}

