/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.ActionSeverity;
import software.amazon.awssdk.services.opensearch.model.ActionStatus;
import software.amazon.awssdk.services.opensearch.model.ActionType;
import software.amazon.awssdk.services.opensearch.model.ScheduledBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledAction> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ScheduledAction.getter(ScheduledAction::id)).setter(ScheduledAction.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ScheduledAction.getter(ScheduledAction::typeAsString)).setter(ScheduledAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ScheduledAction.getter(ScheduledAction::severityAsString)).setter(ScheduledAction.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Long> SCHEDULED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ScheduledTime").getter(ScheduledAction.getter(ScheduledAction::scheduledTime)).setter(ScheduledAction.setter(Builder::scheduledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ScheduledAction.getter(ScheduledAction::description)).setter(ScheduledAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCHEDULED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledBy").getter(ScheduledAction.getter(ScheduledAction::scheduledByAsString)).setter(ScheduledAction.setter(Builder::scheduledBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ScheduledAction.getter(ScheduledAction::statusAsString)).setter(ScheduledAction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> MANDATORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Mandatory").getter(ScheduledAction.getter(ScheduledAction::mandatory)).setter(ScheduledAction.setter(Builder::mandatory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mandatory").build()}).build();
    private static final SdkField<Boolean> CANCELLABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Cancellable").getter(ScheduledAction.getter(ScheduledAction::cancellable)).setter(ScheduledAction.setter(Builder::cancellable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cancellable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, SEVERITY_FIELD, SCHEDULED_TIME_FIELD, DESCRIPTION_FIELD, SCHEDULED_BY_FIELD, STATUS_FIELD, MANDATORY_FIELD, CANCELLABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String severity;
    private final Long scheduledTime;
    private final String description;
    private final String scheduledBy;
    private final String status;
    private final Boolean mandatory;
    private final Boolean cancellable;

    private ScheduledAction(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.severity = builder.severity;
        this.scheduledTime = builder.scheduledTime;
        this.description = builder.description;
        this.scheduledBy = builder.scheduledBy;
        this.status = builder.status;
        this.mandatory = builder.mandatory;
        this.cancellable = builder.cancellable;
    }

    public final String id() {
        return this.id;
    }

    public final ActionType type() {
        return ActionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ActionSeverity severity() {
        return ActionSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final Long scheduledTime() {
        return this.scheduledTime;
    }

    public final String description() {
        return this.description;
    }

    public final ScheduledBy scheduledBy() {
        return ScheduledBy.fromValue(this.scheduledBy);
    }

    public final String scheduledByAsString() {
        return this.scheduledBy;
    }

    public final ActionStatus status() {
        return ActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean mandatory() {
        return this.mandatory;
    }

    public final Boolean cancellable() {
        return this.cancellable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mandatory());
        hashCode = 31 * hashCode + Objects.hashCode(this.cancellable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledAction)) {
            return false;
        }
        ScheduledAction other = (ScheduledAction)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.scheduledTime(), other.scheduledTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scheduledByAsString(), other.scheduledByAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.mandatory(), other.mandatory()) && Objects.equals(this.cancellable(), other.cancellable());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledAction").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Severity", (Object)this.severityAsString()).add("ScheduledTime", (Object)this.scheduledTime()).add("Description", (Object)this.description()).add("ScheduledBy", (Object)this.scheduledByAsString()).add("Status", (Object)this.statusAsString()).add("Mandatory", (Object)this.mandatory()).add("Cancellable", (Object)this.cancellable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "ScheduledTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ScheduledBy": {
                return Optional.ofNullable(clazz.cast(this.scheduledByAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Mandatory": {
                return Optional.ofNullable(clazz.cast(this.mandatory()));
            }
            case "Cancellable": {
                return Optional.ofNullable(clazz.cast(this.cancellable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("ScheduledTime", SCHEDULED_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ScheduledBy", SCHEDULED_BY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Mandatory", MANDATORY_FIELD);
        map.put("Cancellable", CANCELLABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledAction, T> g) {
        return obj -> g.apply((ScheduledAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String severity;
        private Long scheduledTime;
        private String description;
        private String scheduledBy;
        private String status;
        private Boolean mandatory;
        private Boolean cancellable;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledAction model) {
            this.id(model.id);
            this.type(model.type);
            this.severity(model.severity);
            this.scheduledTime(model.scheduledTime);
            this.description(model.description);
            this.scheduledBy(model.scheduledBy);
            this.status(model.status);
            this.mandatory(model.mandatory);
            this.cancellable(model.cancellable);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ActionSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final Long getScheduledTime() {
            return this.scheduledTime;
        }

        public final void setScheduledTime(Long scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Long scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScheduledBy() {
            return this.scheduledBy;
        }

        public final void setScheduledBy(String scheduledBy) {
            this.scheduledBy = scheduledBy;
        }

        @Override
        public final Builder scheduledBy(String scheduledBy) {
            this.scheduledBy = scheduledBy;
            return this;
        }

        @Override
        public final Builder scheduledBy(ScheduledBy scheduledBy) {
            this.scheduledBy(scheduledBy == null ? null : scheduledBy.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getMandatory() {
            return this.mandatory;
        }

        public final void setMandatory(Boolean mandatory) {
            this.mandatory = mandatory;
        }

        @Override
        public final Builder mandatory(Boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public final Boolean getCancellable() {
            return this.cancellable;
        }

        public final void setCancellable(Boolean cancellable) {
            this.cancellable = cancellable;
        }

        @Override
        public final Builder cancellable(Boolean cancellable) {
            this.cancellable = cancellable;
            return this;
        }

        public ScheduledAction build() {
            return new ScheduledAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledAction> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(ActionType var1);

        public Builder severity(String var1);

        public Builder severity(ActionSeverity var1);

        public Builder scheduledTime(Long var1);

        public Builder description(String var1);

        public Builder scheduledBy(String var1);

        public Builder scheduledBy(ScheduledBy var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder mandatory(Boolean var1);

        public Builder cancellable(Boolean var1);
    }
}

