/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.services.opensearch.model.PackageSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePackageRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, UpdatePackageRequest> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageID").getter(UpdatePackageRequest.getter(UpdatePackageRequest::packageID)).setter(UpdatePackageRequest.setter(Builder::packageID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()}).build();
    private static final SdkField<PackageSource> PACKAGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageSource").getter(UpdatePackageRequest.getter(UpdatePackageRequest::packageSource)).setter(UpdatePackageRequest.setter(Builder::packageSource)).constructor(PackageSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageSource").build()}).build();
    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageDescription").getter(UpdatePackageRequest.getter(UpdatePackageRequest::packageDescription)).setter(UpdatePackageRequest.setter(Builder::packageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommitMessage").getter(UpdatePackageRequest.getter(UpdatePackageRequest::commitMessage)).setter(UpdatePackageRequest.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD, PACKAGE_SOURCE_FIELD, PACKAGE_DESCRIPTION_FIELD, COMMIT_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PackageID", PACKAGE_ID_FIELD);
            this.put("PackageSource", PACKAGE_SOURCE_FIELD);
            this.put("PackageDescription", PACKAGE_DESCRIPTION_FIELD);
            this.put("CommitMessage", COMMIT_MESSAGE_FIELD);
        }
    });
    private final String packageID;
    private final PackageSource packageSource;
    private final String packageDescription;
    private final String commitMessage;

    private UpdatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
        this.packageSource = builder.packageSource;
        this.packageDescription = builder.packageDescription;
        this.commitMessage = builder.commitMessage;
    }

    public final String packageID() {
        return this.packageID;
    }

    public final PackageSource packageSource() {
        return this.packageSource;
    }

    public final String packageDescription() {
        return this.packageDescription;
    }

    public final String commitMessage() {
        return this.commitMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageID());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageRequest)) {
            return false;
        }
        UpdatePackageRequest other = (UpdatePackageRequest)((Object)obj);
        return Objects.equals(this.packageID(), other.packageID()) && Objects.equals(this.packageSource(), other.packageSource()) && Objects.equals(this.packageDescription(), other.packageDescription()) && Objects.equals(this.commitMessage(), other.commitMessage());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePackageRequest").add("PackageID", (Object)this.packageID()).add("PackageSource", (Object)this.packageSource()).add("PackageDescription", (Object)this.packageDescription()).add("CommitMessage", (Object)this.commitMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageID": {
                return Optional.ofNullable(clazz.cast(this.packageID()));
            }
            case "PackageSource": {
                return Optional.ofNullable(clazz.cast(this.packageSource()));
            }
            case "PackageDescription": {
                return Optional.ofNullable(clazz.cast(this.packageDescription()));
            }
            case "CommitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageRequest, T> g) {
        return obj -> g.apply((UpdatePackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String packageID;
        private PackageSource packageSource;
        private String packageDescription;
        private String commitMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageRequest model) {
            super(model);
            this.packageID(model.packageID);
            this.packageSource(model.packageSource);
            this.packageDescription(model.packageDescription);
            this.commitMessage(model.commitMessage);
        }

        public final String getPackageID() {
            return this.packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final PackageSource.Builder getPackageSource() {
            return this.packageSource != null ? this.packageSource.toBuilder() : null;
        }

        public final void setPackageSource(PackageSource.BuilderImpl packageSource) {
            this.packageSource = packageSource != null ? packageSource.build() : null;
        }

        @Override
        public final Builder packageSource(PackageSource packageSource) {
            this.packageSource = packageSource;
            return this;
        }

        public final String getPackageDescription() {
            return this.packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageRequest build() {
            return new UpdatePackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePackageRequest> {
        public Builder packageID(String var1);

        public Builder packageSource(PackageSource var1);

        default public Builder packageSource(Consumer<PackageSource.Builder> packageSource) {
            return this.packageSource((PackageSource)((PackageSource.Builder)PackageSource.builder().applyMutation(packageSource)).build());
        }

        public Builder packageDescription(String var1);

        public Builder commitMessage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

