/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.AppConfig;
import software.amazon.awssdk.services.opensearch.model.AppConfigsCopier;
import software.amazon.awssdk.services.opensearch.model.DataSource;
import software.amazon.awssdk.services.opensearch.model.DataSourcesCopier;
import software.amazon.awssdk.services.opensearch.model.IamIdentityCenterOptions;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, UpdateApplicationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::id)).setter(UpdateApplicationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::name)).setter(UpdateApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::arn)).setter(UpdateApplicationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSources").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::dataSources)).setter(UpdateApplicationResponse.setter(Builder::dataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IamIdentityCenterOptions> IAM_IDENTITY_CENTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptions").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::iamIdentityCenterOptions)).setter(UpdateApplicationResponse.setter(Builder::iamIdentityCenterOptions)).constructor(IamIdentityCenterOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptions").build()}).build();
    private static final SdkField<List<AppConfig>> APP_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appConfigs").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::appConfigs)).setter(UpdateApplicationResponse.setter(Builder::appConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::createdAt)).setter(UpdateApplicationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::lastUpdatedAt)).setter(UpdateApplicationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, DATA_SOURCES_FIELD, IAM_IDENTITY_CENTER_OPTIONS_FIELD, APP_CONFIGS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private final String id;
    private final String name;
    private final String arn;
    private final List<DataSource> dataSources;
    private final IamIdentityCenterOptions iamIdentityCenterOptions;
    private final List<AppConfig> appConfigs;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private UpdateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.dataSources = builder.dataSources;
        this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
        this.appConfigs = builder.appConfigs;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public final List<DataSource> dataSources() {
        return this.dataSources;
    }

    public final IamIdentityCenterOptions iamIdentityCenterOptions() {
        return this.iamIdentityCenterOptions;
    }

    public final boolean hasAppConfigs() {
        return this.appConfigs != null && !(this.appConfigs instanceof SdkAutoConstructList);
    }

    public final List<AppConfig> appConfigs() {
        return this.appConfigs;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSources() ? this.dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppConfigs() ? this.appConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationResponse)) {
            return false;
        }
        UpdateApplicationResponse other = (UpdateApplicationResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && this.hasDataSources() == other.hasDataSources() && Objects.equals(this.dataSources(), other.dataSources()) && Objects.equals(this.iamIdentityCenterOptions(), other.iamIdentityCenterOptions()) && this.hasAppConfigs() == other.hasAppConfigs() && Objects.equals(this.appConfigs(), other.appConfigs()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("DataSources", this.hasDataSources() ? this.dataSources() : null).add("IamIdentityCenterOptions", (Object)this.iamIdentityCenterOptions()).add("AppConfigs", this.hasAppConfigs() ? this.appConfigs() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "dataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "iamIdentityCenterOptions": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterOptions()));
            }
            case "appConfigs": {
                return Optional.ofNullable(clazz.cast(this.appConfigs()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationResponse, T> g) {
        return obj -> g.apply((UpdateApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();
        private IamIdentityCenterOptions iamIdentityCenterOptions;
        private List<AppConfig> appConfigs = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.dataSources(model.dataSources);
            this.iamIdentityCenterOptions(model.iamIdentityCenterOptions);
            this.appConfigs(model.appConfigs);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<DataSource.Builder> getDataSources() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder> ... dataSources) {
            this.dataSources(Stream.of(dataSources).map(c -> (DataSource)((DataSource.Builder)DataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IamIdentityCenterOptions.Builder getIamIdentityCenterOptions() {
            return this.iamIdentityCenterOptions != null ? this.iamIdentityCenterOptions.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptions(IamIdentityCenterOptions.BuilderImpl iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions != null ? iamIdentityCenterOptions.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptions(IamIdentityCenterOptions iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        public final List<AppConfig.Builder> getAppConfigs() {
            List<AppConfig.Builder> result = AppConfigsCopier.copyToBuilder(this.appConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppConfigs(Collection<AppConfig.BuilderImpl> appConfigs) {
            this.appConfigs = AppConfigsCopier.copyFromBuilder(appConfigs);
        }

        @Override
        public final Builder appConfigs(Collection<AppConfig> appConfigs) {
            this.appConfigs = AppConfigsCopier.copy(appConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(AppConfig ... appConfigs) {
            this.appConfigs(Arrays.asList(appConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(Consumer<AppConfig.Builder> ... appConfigs) {
            this.appConfigs(Stream.of(appConfigs).map(c -> (AppConfig)((AppConfig.Builder)AppConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public UpdateApplicationResponse build() {
            return new UpdateApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder dataSources(Consumer<DataSource.Builder> ... var1);

        public Builder iamIdentityCenterOptions(IamIdentityCenterOptions var1);

        default public Builder iamIdentityCenterOptions(Consumer<IamIdentityCenterOptions.Builder> iamIdentityCenterOptions) {
            return this.iamIdentityCenterOptions((IamIdentityCenterOptions)((IamIdentityCenterOptions.Builder)IamIdentityCenterOptions.builder().applyMutation(iamIdentityCenterOptions)).build());
        }

        public Builder appConfigs(Collection<AppConfig> var1);

        public Builder appConfigs(AppConfig ... var1);

        public Builder appConfigs(Consumer<AppConfig.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

