/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSource> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceArn").getter(DataSource.getter(DataSource::dataSourceArn)).setter(DataSource.setter(Builder::dataSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceArn").build()}).build();
    private static final SdkField<String> DATA_SOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceDescription").getter(DataSource.getter(DataSource::dataSourceDescription)).setter(DataSource.setter(Builder::dataSourceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD, DATA_SOURCE_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSourceArn;
    private final String dataSourceDescription;

    private DataSource(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.dataSourceDescription = builder.dataSourceDescription;
    }

    public final String dataSourceArn() {
        return this.dataSourceArn;
    }

    public final String dataSourceDescription() {
        return this.dataSourceDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        return Objects.equals(this.dataSourceArn(), other.dataSourceArn()) && Objects.equals(this.dataSourceDescription(), other.dataSourceDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DataSource").add("DataSourceArn", (Object)this.dataSourceArn()).add("DataSourceDescription", (Object)this.dataSourceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceArn": {
                return Optional.ofNullable(clazz.cast(this.dataSourceArn()));
            }
            case "dataSourceDescription": {
                return Optional.ofNullable(clazz.cast(this.dataSourceDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceArn;
        private String dataSourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            this.dataSourceArn(model.dataSourceArn);
            this.dataSourceDescription(model.dataSourceDescription);
        }

        public final String getDataSourceArn() {
            return this.dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final String getDataSourceDescription() {
            return this.dataSourceDescription;
        }

        public final void setDataSourceDescription(String dataSourceDescription) {
            this.dataSourceDescription = dataSourceDescription;
        }

        @Override
        public final Builder dataSourceDescription(String dataSourceDescription) {
            this.dataSourceDescription = dataSourceDescription;
            return this;
        }

        public DataSource build() {
            return new DataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSource> {
        public Builder dataSourceArn(String var1);

        public Builder dataSourceDescription(String var1);
    }
}

