/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.AWSServicePrincipal;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizeVpcEndpointAccessRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, AuthorizeVpcEndpointAccessRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AuthorizeVpcEndpointAccessRequest.getter(AuthorizeVpcEndpointAccessRequest::domainName)).setter(AuthorizeVpcEndpointAccessRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Account").getter(AuthorizeVpcEndpointAccessRequest.getter(AuthorizeVpcEndpointAccessRequest::account)).setter(AuthorizeVpcEndpointAccessRequest.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(AuthorizeVpcEndpointAccessRequest.getter(AuthorizeVpcEndpointAccessRequest::serviceAsString)).setter(AuthorizeVpcEndpointAccessRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ACCOUNT_FIELD, SERVICE_FIELD));
    private final String domainName;
    private final String account;
    private final String service;

    private AuthorizeVpcEndpointAccessRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.account = builder.account;
        this.service = builder.service;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String account() {
        return this.account;
    }

    public final AWSServicePrincipal service() {
        return AWSServicePrincipal.fromValue(this.service);
    }

    public final String serviceAsString() {
        return this.service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeVpcEndpointAccessRequest)) {
            return false;
        }
        AuthorizeVpcEndpointAccessRequest other = (AuthorizeVpcEndpointAccessRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.account(), other.account()) && Objects.equals(this.serviceAsString(), other.serviceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizeVpcEndpointAccessRequest").add("DomainName", (Object)this.domainName()).add("Account", (Object)this.account()).add("Service", (Object)this.serviceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.serviceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeVpcEndpointAccessRequest, T> g) {
        return obj -> g.apply((AuthorizeVpcEndpointAccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String account;
        private String service;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeVpcEndpointAccessRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.account(model.account);
            this.service(model.service);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(AWSServicePrincipal service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeVpcEndpointAccessRequest build() {
            return new AuthorizeVpcEndpointAccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AuthorizeVpcEndpointAccessRequest> {
        public Builder domainName(String var1);

        public Builder account(String var1);

        public Builder service(String var1);

        public Builder service(AWSServicePrincipal var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

