/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.ZoneStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityZoneInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityZoneInfo> {
    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneName").getter(AvailabilityZoneInfo.getter(AvailabilityZoneInfo::availabilityZoneName)).setter(AvailabilityZoneInfo.setter(Builder::availabilityZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build()}).build();
    private static final SdkField<String> ZONE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneStatus").getter(AvailabilityZoneInfo.getter(AvailabilityZoneInfo::zoneStatusAsString)).setter(AvailabilityZoneInfo.setter(Builder::zoneStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneStatus").build()}).build();
    private static final SdkField<String> CONFIGURED_DATA_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfiguredDataNodeCount").getter(AvailabilityZoneInfo.getter(AvailabilityZoneInfo::configuredDataNodeCount)).setter(AvailabilityZoneInfo.setter(Builder::configuredDataNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfiguredDataNodeCount").build()}).build();
    private static final SdkField<String> AVAILABLE_DATA_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailableDataNodeCount").getter(AvailabilityZoneInfo.getter(AvailabilityZoneInfo::availableDataNodeCount)).setter(AvailabilityZoneInfo.setter(Builder::availableDataNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableDataNodeCount").build()}).build();
    private static final SdkField<String> TOTAL_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalShards").getter(AvailabilityZoneInfo.getter(AvailabilityZoneInfo::totalShards)).setter(AvailabilityZoneInfo.setter(Builder::totalShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalShards").build()}).build();
    private static final SdkField<String> TOTAL_UN_ASSIGNED_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalUnAssignedShards").getter(AvailabilityZoneInfo.getter(AvailabilityZoneInfo::totalUnAssignedShards)).setter(AvailabilityZoneInfo.setter(Builder::totalUnAssignedShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalUnAssignedShards").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_NAME_FIELD, ZONE_STATUS_FIELD, CONFIGURED_DATA_NODE_COUNT_FIELD, AVAILABLE_DATA_NODE_COUNT_FIELD, TOTAL_SHARDS_FIELD, TOTAL_UN_ASSIGNED_SHARDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AvailabilityZoneName", AVAILABILITY_ZONE_NAME_FIELD);
            this.put("ZoneStatus", ZONE_STATUS_FIELD);
            this.put("ConfiguredDataNodeCount", CONFIGURED_DATA_NODE_COUNT_FIELD);
            this.put("AvailableDataNodeCount", AVAILABLE_DATA_NODE_COUNT_FIELD);
            this.put("TotalShards", TOTAL_SHARDS_FIELD);
            this.put("TotalUnAssignedShards", TOTAL_UN_ASSIGNED_SHARDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String availabilityZoneName;
    private final String zoneStatus;
    private final String configuredDataNodeCount;
    private final String availableDataNodeCount;
    private final String totalShards;
    private final String totalUnAssignedShards;

    private AvailabilityZoneInfo(BuilderImpl builder) {
        this.availabilityZoneName = builder.availabilityZoneName;
        this.zoneStatus = builder.zoneStatus;
        this.configuredDataNodeCount = builder.configuredDataNodeCount;
        this.availableDataNodeCount = builder.availableDataNodeCount;
        this.totalShards = builder.totalShards;
        this.totalUnAssignedShards = builder.totalUnAssignedShards;
    }

    public final String availabilityZoneName() {
        return this.availabilityZoneName;
    }

    public final ZoneStatus zoneStatus() {
        return ZoneStatus.fromValue(this.zoneStatus);
    }

    public final String zoneStatusAsString() {
        return this.zoneStatus;
    }

    public final String configuredDataNodeCount() {
        return this.configuredDataNodeCount;
    }

    public final String availableDataNodeCount() {
        return this.availableDataNodeCount;
    }

    public final String totalShards() {
        return this.totalShards;
    }

    public final String totalUnAssignedShards() {
        return this.totalUnAssignedShards;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredDataNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableDataNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalUnAssignedShards());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZoneInfo)) {
            return false;
        }
        AvailabilityZoneInfo other = (AvailabilityZoneInfo)obj;
        return Objects.equals(this.availabilityZoneName(), other.availabilityZoneName()) && Objects.equals(this.zoneStatusAsString(), other.zoneStatusAsString()) && Objects.equals(this.configuredDataNodeCount(), other.configuredDataNodeCount()) && Objects.equals(this.availableDataNodeCount(), other.availableDataNodeCount()) && Objects.equals(this.totalShards(), other.totalShards()) && Objects.equals(this.totalUnAssignedShards(), other.totalUnAssignedShards());
    }

    public final String toString() {
        return ToString.builder((String)"AvailabilityZoneInfo").add("AvailabilityZoneName", (Object)this.availabilityZoneName()).add("ZoneStatus", (Object)this.zoneStatusAsString()).add("ConfiguredDataNodeCount", (Object)this.configuredDataNodeCount()).add("AvailableDataNodeCount", (Object)this.availableDataNodeCount()).add("TotalShards", (Object)this.totalShards()).add("TotalUnAssignedShards", (Object)this.totalUnAssignedShards()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZoneName": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneName()));
            }
            case "ZoneStatus": {
                return Optional.ofNullable(clazz.cast(this.zoneStatusAsString()));
            }
            case "ConfiguredDataNodeCount": {
                return Optional.ofNullable(clazz.cast(this.configuredDataNodeCount()));
            }
            case "AvailableDataNodeCount": {
                return Optional.ofNullable(clazz.cast(this.availableDataNodeCount()));
            }
            case "TotalShards": {
                return Optional.ofNullable(clazz.cast(this.totalShards()));
            }
            case "TotalUnAssignedShards": {
                return Optional.ofNullable(clazz.cast(this.totalUnAssignedShards()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZoneInfo, T> g) {
        return obj -> g.apply((AvailabilityZoneInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZoneName;
        private String zoneStatus;
        private String configuredDataNodeCount;
        private String availableDataNodeCount;
        private String totalShards;
        private String totalUnAssignedShards;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZoneInfo model) {
            this.availabilityZoneName(model.availabilityZoneName);
            this.zoneStatus(model.zoneStatus);
            this.configuredDataNodeCount(model.configuredDataNodeCount);
            this.availableDataNodeCount(model.availableDataNodeCount);
            this.totalShards(model.totalShards);
            this.totalUnAssignedShards(model.totalUnAssignedShards);
        }

        public final String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        @Override
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final String getZoneStatus() {
            return this.zoneStatus;
        }

        public final void setZoneStatus(String zoneStatus) {
            this.zoneStatus = zoneStatus;
        }

        @Override
        public final Builder zoneStatus(String zoneStatus) {
            this.zoneStatus = zoneStatus;
            return this;
        }

        @Override
        public final Builder zoneStatus(ZoneStatus zoneStatus) {
            this.zoneStatus(zoneStatus == null ? null : zoneStatus.toString());
            return this;
        }

        public final String getConfiguredDataNodeCount() {
            return this.configuredDataNodeCount;
        }

        public final void setConfiguredDataNodeCount(String configuredDataNodeCount) {
            this.configuredDataNodeCount = configuredDataNodeCount;
        }

        @Override
        public final Builder configuredDataNodeCount(String configuredDataNodeCount) {
            this.configuredDataNodeCount = configuredDataNodeCount;
            return this;
        }

        public final String getAvailableDataNodeCount() {
            return this.availableDataNodeCount;
        }

        public final void setAvailableDataNodeCount(String availableDataNodeCount) {
            this.availableDataNodeCount = availableDataNodeCount;
        }

        @Override
        public final Builder availableDataNodeCount(String availableDataNodeCount) {
            this.availableDataNodeCount = availableDataNodeCount;
            return this;
        }

        public final String getTotalShards() {
            return this.totalShards;
        }

        public final void setTotalShards(String totalShards) {
            this.totalShards = totalShards;
        }

        @Override
        public final Builder totalShards(String totalShards) {
            this.totalShards = totalShards;
            return this;
        }

        public final String getTotalUnAssignedShards() {
            return this.totalUnAssignedShards;
        }

        public final void setTotalUnAssignedShards(String totalUnAssignedShards) {
            this.totalUnAssignedShards = totalUnAssignedShards;
        }

        @Override
        public final Builder totalUnAssignedShards(String totalUnAssignedShards) {
            this.totalUnAssignedShards = totalUnAssignedShards;
            return this;
        }

        public AvailabilityZoneInfo build() {
            return new AvailabilityZoneInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityZoneInfo> {
        public Builder availabilityZoneName(String var1);

        public Builder zoneStatus(String var1);

        public Builder zoneStatus(ZoneStatus var1);

        public Builder configuredDataNodeCount(String var1);

        public Builder availableDataNodeCount(String var1);

        public Builder totalShards(String var1);

        public Builder totalUnAssignedShards(String var1);
    }
}

