/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse;

public class ListInstanceTypeDetailsPublisher
implements SdkPublisher<ListInstanceTypeDetailsResponse> {
    private final OpenSearchAsyncClient client;
    private final ListInstanceTypeDetailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceTypeDetailsPublisher(OpenSearchAsyncClient client, ListInstanceTypeDetailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceTypeDetailsPublisher(OpenSearchAsyncClient client, ListInstanceTypeDetailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceTypeDetailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceTypeDetailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInstanceTypeDetailsResponseFetcher
    implements AsyncPageFetcher<ListInstanceTypeDetailsResponse> {
        private ListInstanceTypeDetailsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceTypeDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInstanceTypeDetailsResponse> nextPage(ListInstanceTypeDetailsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceTypeDetailsPublisher.this.client.listInstanceTypeDetails(ListInstanceTypeDetailsPublisher.this.firstRequest);
            }
            return ListInstanceTypeDetailsPublisher.this.client.listInstanceTypeDetails((ListInstanceTypeDetailsRequest)((Object)ListInstanceTypeDetailsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

