/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.UpgradeStatus;
import software.amazon.awssdk.services.opensearch.model.UpgradeStepItem;
import software.amazon.awssdk.services.opensearch.model.UpgradeStepsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpgradeHistory> {
    private static final SdkField<String> UPGRADE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpgradeName").getter(UpgradeHistory.getter(UpgradeHistory::upgradeName)).setter(UpgradeHistory.setter(Builder::upgradeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeName").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(UpgradeHistory.getter(UpgradeHistory::startTimestamp)).setter(UpgradeHistory.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<String> UPGRADE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpgradeStatus").getter(UpgradeHistory.getter(UpgradeHistory::upgradeStatusAsString)).setter(UpgradeHistory.setter(Builder::upgradeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStatus").build()}).build();
    private static final SdkField<List<UpgradeStepItem>> STEPS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepsList").getter(UpgradeHistory.getter(UpgradeHistory::stepsList)).setter(UpgradeHistory.setter(Builder::stepsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpgradeStepItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_NAME_FIELD, START_TIMESTAMP_FIELD, UPGRADE_STATUS_FIELD, STEPS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UpgradeName", UPGRADE_NAME_FIELD);
            this.put("StartTimestamp", START_TIMESTAMP_FIELD);
            this.put("UpgradeStatus", UPGRADE_STATUS_FIELD);
            this.put("StepsList", STEPS_LIST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String upgradeName;
    private final Instant startTimestamp;
    private final String upgradeStatus;
    private final List<UpgradeStepItem> stepsList;

    private UpgradeHistory(BuilderImpl builder) {
        this.upgradeName = builder.upgradeName;
        this.startTimestamp = builder.startTimestamp;
        this.upgradeStatus = builder.upgradeStatus;
        this.stepsList = builder.stepsList;
    }

    public final String upgradeName() {
        return this.upgradeName;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final UpgradeStatus upgradeStatus() {
        return UpgradeStatus.fromValue(this.upgradeStatus);
    }

    public final String upgradeStatusAsString() {
        return this.upgradeStatus;
    }

    public final boolean hasStepsList() {
        return this.stepsList != null && !(this.stepsList instanceof SdkAutoConstructList);
    }

    public final List<UpgradeStepItem> stepsList() {
        return this.stepsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepsList() ? this.stepsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeHistory)) {
            return false;
        }
        UpgradeHistory other = (UpgradeHistory)obj;
        return Objects.equals(this.upgradeName(), other.upgradeName()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.upgradeStatusAsString(), other.upgradeStatusAsString()) && this.hasStepsList() == other.hasStepsList() && Objects.equals(this.stepsList(), other.stepsList());
    }

    public final String toString() {
        return ToString.builder((String)"UpgradeHistory").add("UpgradeName", (Object)this.upgradeName()).add("StartTimestamp", (Object)this.startTimestamp()).add("UpgradeStatus", (Object)this.upgradeStatusAsString()).add("StepsList", this.hasStepsList() ? this.stepsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradeName": {
                return Optional.ofNullable(clazz.cast(this.upgradeName()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "UpgradeStatus": {
                return Optional.ofNullable(clazz.cast(this.upgradeStatusAsString()));
            }
            case "StepsList": {
                return Optional.ofNullable(clazz.cast(this.stepsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeHistory, T> g) {
        return obj -> g.apply((UpgradeHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String upgradeName;
        private Instant startTimestamp;
        private String upgradeStatus;
        private List<UpgradeStepItem> stepsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeHistory model) {
            this.upgradeName(model.upgradeName);
            this.startTimestamp(model.startTimestamp);
            this.upgradeStatus(model.upgradeStatus);
            this.stepsList(model.stepsList);
        }

        public final String getUpgradeName() {
            return this.upgradeName;
        }

        public final void setUpgradeName(String upgradeName) {
            this.upgradeName = upgradeName;
        }

        @Override
        public final Builder upgradeName(String upgradeName) {
            this.upgradeName = upgradeName;
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final String getUpgradeStatus() {
            return this.upgradeStatus;
        }

        public final void setUpgradeStatus(String upgradeStatus) {
            this.upgradeStatus = upgradeStatus;
        }

        @Override
        public final Builder upgradeStatus(String upgradeStatus) {
            this.upgradeStatus = upgradeStatus;
            return this;
        }

        @Override
        public final Builder upgradeStatus(UpgradeStatus upgradeStatus) {
            this.upgradeStatus(upgradeStatus == null ? null : upgradeStatus.toString());
            return this;
        }

        public final List<UpgradeStepItem.Builder> getStepsList() {
            List<UpgradeStepItem.Builder> result = UpgradeStepsListCopier.copyToBuilder(this.stepsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepsList(Collection<UpgradeStepItem.BuilderImpl> stepsList) {
            this.stepsList = UpgradeStepsListCopier.copyFromBuilder(stepsList);
        }

        @Override
        public final Builder stepsList(Collection<UpgradeStepItem> stepsList) {
            this.stepsList = UpgradeStepsListCopier.copy(stepsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepsList(UpgradeStepItem ... stepsList) {
            this.stepsList(Arrays.asList(stepsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepsList(Consumer<UpgradeStepItem.Builder> ... stepsList) {
            this.stepsList(Stream.of(stepsList).map(c -> (UpgradeStepItem)((UpgradeStepItem.Builder)UpgradeStepItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UpgradeHistory build() {
            return new UpgradeHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpgradeHistory> {
        public Builder upgradeName(String var1);

        public Builder startTimestamp(Instant var1);

        public Builder upgradeStatus(String var1);

        public Builder upgradeStatus(UpgradeStatus var1);

        public Builder stepsList(Collection<UpgradeStepItem> var1);

        public Builder stepsList(UpgradeStepItem ... var1);

        public Builder stepsList(Consumer<UpgradeStepItem.Builder> ... var1);
    }
}

