/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.OpenSearchServiceClientConfiguration;
import software.amazon.awssdk.services.opensearch.internal.OpenSearchServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.AccessDeniedException;
import software.amazon.awssdk.services.opensearch.model.AddDataSourceRequest;
import software.amazon.awssdk.services.opensearch.model.AddDataSourceResponse;
import software.amazon.awssdk.services.opensearch.model.AddTagsRequest;
import software.amazon.awssdk.services.opensearch.model.AddTagsResponse;
import software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.BaseException;
import software.amazon.awssdk.services.opensearch.model.CancelDomainConfigChangeRequest;
import software.amazon.awssdk.services.opensearch.model.CancelDomainConfigChangeResponse;
import software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.opensearch.model.ConflictException;
import software.amazon.awssdk.services.opensearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.opensearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.CreatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.CreatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.DeletePackageRequest;
import software.amazon.awssdk.services.opensearch.model.DeletePackageResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.DependencyFailureException;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.opensearch.model.DisabledOperationException;
import software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.DissociatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse;
import software.amazon.awssdk.services.opensearch.model.GetDataSourceRequest;
import software.amazon.awssdk.services.opensearch.model.GetDataSourceResponse;
import software.amazon.awssdk.services.opensearch.model.GetDomainMaintenanceStatusRequest;
import software.amazon.awssdk.services.opensearch.model.GetDomainMaintenanceStatusResponse;
import software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.opensearch.model.InternalException;
import software.amazon.awssdk.services.opensearch.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.opensearch.model.InvalidTypeException;
import software.amazon.awssdk.services.opensearch.model.LimitExceededException;
import software.amazon.awssdk.services.opensearch.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse;
import software.amazon.awssdk.services.opensearch.model.ListTagsRequest;
import software.amazon.awssdk.services.opensearch.model.ListTagsResponse;
import software.amazon.awssdk.services.opensearch.model.ListVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVersionsResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsResponse;
import software.amazon.awssdk.services.opensearch.model.OpenSearchException;
import software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest;
import software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse;
import software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.opensearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.opensearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.opensearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.SlotNotAvailableException;
import software.amazon.awssdk.services.opensearch.model.StartDomainMaintenanceRequest;
import software.amazon.awssdk.services.opensearch.model.StartDomainMaintenanceResponse;
import software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse;
import software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest;
import software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ValidationException;
import software.amazon.awssdk.services.opensearch.transform.AcceptInboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.AddDataSourceRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.AssociatePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.AuthorizeVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CancelDomainConfigChangeRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CancelServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CreateOutboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CreateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteInboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteOutboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainAutoTunesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainChangeProgressRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainHealthRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainNodesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDryRunProgressRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeInboundConnectionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeInstanceTypeLimitsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeOutboundConnectionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribePackagesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeReservedInstanceOfferingsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DissociatePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetCompatibleVersionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetDomainMaintenanceStatusRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetPackageVersionHistoryRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetUpgradeHistoryRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetUpgradeStatusRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListDomainMaintenancesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListDomainsForPackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListInstanceTypeDetailsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListPackagesForDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListVersionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListVpcEndpointsForDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.PurchaseReservedInstanceOfferingRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.RejectInboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.RevokeVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.StartDomainMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.StartServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdateDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdatePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdateScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpgradeDomainRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultOpenSearchClient
implements OpenSearchClient {
    private static final Logger log = Logger.loggerFor(DefaultOpenSearchClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOpenSearchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptInboundConnectionResponse acceptInboundConnection(AcceptInboundConnectionRequest acceptInboundConnectionRequest) throws ResourceNotFoundException, LimitExceededException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptInboundConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptInboundConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, acceptInboundConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptInboundConnection");
            AcceptInboundConnectionResponse acceptInboundConnectionResponse = (AcceptInboundConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptInboundConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptInboundConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptInboundConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptInboundConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$acceptInboundConnection$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddDataSourceResponse addDataSource(AddDataSourceRequest addDataSourceRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, DependencyFailureException, LimitExceededException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, addDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddDataSource");
            AddDataSourceResponse addDataSourceResponse = (AddDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$addDataSource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws BaseException, LimitExceededException, ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            AddTagsResponse addTagsResponse = (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$addTags$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociatePackageResponse associatePackage(AssociatePackageRequest associatePackageRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociatePackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, associatePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociatePackage");
            AssociatePackageResponse associatePackageResponse = (AssociatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associatePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associatePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$associatePackage$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizeVpcEndpointAccessResponse authorizeVpcEndpointAccess(AuthorizeVpcEndpointAccessRequest authorizeVpcEndpointAccessRequest) throws ResourceNotFoundException, DisabledOperationException, LimitExceededException, ValidationException, InternalException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AuthorizeVpcEndpointAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)authorizeVpcEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, authorizeVpcEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeVpcEndpointAccess");
            AuthorizeVpcEndpointAccessResponse authorizeVpcEndpointAccessResponse = (AuthorizeVpcEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeVpcEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)authorizeVpcEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AuthorizeVpcEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return authorizeVpcEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$authorizeVpcEndpointAccess$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelDomainConfigChangeResponse cancelDomainConfigChange(CancelDomainConfigChangeRequest cancelDomainConfigChangeRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelDomainConfigChangeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelDomainConfigChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, cancelDomainConfigChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelDomainConfigChange");
            CancelDomainConfigChangeResponse cancelDomainConfigChangeResponse = (CancelDomainConfigChangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelDomainConfigChange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelDomainConfigChangeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelDomainConfigChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelDomainConfigChangeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$cancelDomainConfigChange$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelServiceSoftwareUpdateResponse cancelServiceSoftwareUpdate(CancelServiceSoftwareUpdateRequest cancelServiceSoftwareUpdateRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelServiceSoftwareUpdateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelServiceSoftwareUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, cancelServiceSoftwareUpdateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelServiceSoftwareUpdate");
            CancelServiceSoftwareUpdateResponse cancelServiceSoftwareUpdateResponse = (CancelServiceSoftwareUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelServiceSoftwareUpdate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelServiceSoftwareUpdateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelServiceSoftwareUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelServiceSoftwareUpdateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$cancelServiceSoftwareUpdate$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws BaseException, DisabledOperationException, InternalException, InvalidTypeException, LimitExceededException, ResourceAlreadyExistsException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, createDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomain");
            CreateDomainResponse createDomainResponse = (CreateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$createDomain$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOutboundConnectionResponse createOutboundConnection(CreateOutboundConnectionRequest createOutboundConnectionRequest) throws LimitExceededException, InternalException, ResourceAlreadyExistsException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOutboundConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createOutboundConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, createOutboundConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOutboundConnection");
            CreateOutboundConnectionResponse createOutboundConnectionResponse = (CreateOutboundConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOutboundConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createOutboundConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateOutboundConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createOutboundConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$createOutboundConnection$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceAlreadyExistsException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, createPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePackage");
            CreatePackageResponse createPackageResponse = (CreatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$createPackage$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVpcEndpointResponse createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) throws ConflictException, ValidationException, LimitExceededException, InternalException, DisabledOperationException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVpcEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVpcEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, createVpcEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVpcEndpoint");
            CreateVpcEndpointResponse createVpcEndpointResponse = (CreateVpcEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVpcEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVpcEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVpcEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVpcEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$createVpcEndpoint$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, DependencyFailureException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataSource");
            DeleteDataSourceResponse deleteDataSourceResponse = (DeleteDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$deleteDataSource$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, deleteDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomain");
            DeleteDomainResponse deleteDomainResponse = (DeleteDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$deleteDomain$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInboundConnectionResponse deleteInboundConnection(DeleteInboundConnectionRequest deleteInboundConnectionRequest) throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInboundConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInboundConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, deleteInboundConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInboundConnection");
            DeleteInboundConnectionResponse deleteInboundConnectionResponse = (DeleteInboundConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInboundConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInboundConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInboundConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInboundConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$deleteInboundConnection$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOutboundConnectionResponse deleteOutboundConnection(DeleteOutboundConnectionRequest deleteOutboundConnectionRequest) throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOutboundConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteOutboundConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, deleteOutboundConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOutboundConnection");
            DeleteOutboundConnectionResponse deleteOutboundConnectionResponse = (DeleteOutboundConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOutboundConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteOutboundConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteOutboundConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteOutboundConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$deleteOutboundConnection$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, deletePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePackage");
            DeletePackageResponse deletePackageResponse = (DeletePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$deletePackage$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVpcEndpointResponse deleteVpcEndpoint(DeleteVpcEndpointRequest deleteVpcEndpointRequest) throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVpcEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVpcEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, deleteVpcEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVpcEndpoint");
            DeleteVpcEndpointResponse deleteVpcEndpointResponse = (DeleteVpcEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVpcEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVpcEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVpcEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVpcEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$deleteVpcEndpoint$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomain");
            DescribeDomainResponse describeDomainResponse = (DescribeDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeDomain$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainAutoTunesResponse describeDomainAutoTunes(DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainAutoTunesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainAutoTunesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeDomainAutoTunesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainAutoTunes");
            DescribeDomainAutoTunesResponse describeDomainAutoTunesResponse = (DescribeDomainAutoTunesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainAutoTunes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainAutoTunesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainAutoTunesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainAutoTunesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeDomainAutoTunes$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainChangeProgressResponse describeDomainChangeProgress(DescribeDomainChangeProgressRequest describeDomainChangeProgressRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainChangeProgressResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainChangeProgressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeDomainChangeProgressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainChangeProgress");
            DescribeDomainChangeProgressResponse describeDomainChangeProgressResponse = (DescribeDomainChangeProgressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainChangeProgress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainChangeProgressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainChangeProgressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainChangeProgressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeDomainChangeProgress$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainConfigResponse describeDomainConfig(DescribeDomainConfigRequest describeDomainConfigRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeDomainConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainConfig");
            DescribeDomainConfigResponse describeDomainConfigResponse = (DescribeDomainConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeDomainConfig$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainHealthResponse describeDomainHealth(DescribeDomainHealthRequest describeDomainHealthRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainHealthResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainHealthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeDomainHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainHealth");
            DescribeDomainHealthResponse describeDomainHealthResponse = (DescribeDomainHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainHealth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainHealthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainHealthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainHealthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeDomainHealth$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainNodesResponse describeDomainNodes(DescribeDomainNodesRequest describeDomainNodesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, DependencyFailureException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainNodesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeDomainNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainNodes");
            DescribeDomainNodesResponse describeDomainNodesResponse = (DescribeDomainNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainNodes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainNodesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainNodesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeDomainNodes$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainsResponse describeDomains(DescribeDomainsRequest describeDomainsRequest) throws BaseException, InternalException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomains");
            DescribeDomainsResponse describeDomainsResponse = (DescribeDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomains").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeDomains$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDryRunProgressResponse describeDryRunProgress(DescribeDryRunProgressRequest describeDryRunProgressRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDryRunProgressResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDryRunProgressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeDryRunProgressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDryRunProgress");
            DescribeDryRunProgressResponse describeDryRunProgressResponse = (DescribeDryRunProgressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDryRunProgress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDryRunProgressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDryRunProgressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDryRunProgressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeDryRunProgress$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInboundConnectionsResponse describeInboundConnections(DescribeInboundConnectionsRequest describeInboundConnectionsRequest) throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInboundConnectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInboundConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeInboundConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInboundConnections");
            DescribeInboundConnectionsResponse describeInboundConnectionsResponse = (DescribeInboundConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInboundConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInboundConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInboundConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInboundConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeInboundConnections$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceTypeLimitsResponse describeInstanceTypeLimits(DescribeInstanceTypeLimitsRequest describeInstanceTypeLimitsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInstanceTypeLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInstanceTypeLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeInstanceTypeLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInstanceTypeLimits");
            DescribeInstanceTypeLimitsResponse describeInstanceTypeLimitsResponse = (DescribeInstanceTypeLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceTypeLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInstanceTypeLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInstanceTypeLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInstanceTypeLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeInstanceTypeLimits$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOutboundConnectionsResponse describeOutboundConnections(DescribeOutboundConnectionsRequest describeOutboundConnectionsRequest) throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOutboundConnectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOutboundConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeOutboundConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOutboundConnections");
            DescribeOutboundConnectionsResponse describeOutboundConnectionsResponse = (DescribeOutboundConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOutboundConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOutboundConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOutboundConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOutboundConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeOutboundConnections$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackagesResponse describePackages(DescribePackagesRequest describePackagesRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describePackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackages");
            DescribePackagesResponse describePackagesResponse = (DescribePackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describePackages$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReservedInstanceOfferingsResponse describeReservedInstanceOfferings(DescribeReservedInstanceOfferingsRequest describeReservedInstanceOfferingsRequest) throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedInstanceOfferingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedInstanceOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeReservedInstanceOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedInstanceOfferings");
            DescribeReservedInstanceOfferingsResponse describeReservedInstanceOfferingsResponse = (DescribeReservedInstanceOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedInstanceOfferings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReservedInstanceOfferingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReservedInstanceOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReservedInstanceOfferingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeReservedInstanceOfferings$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReservedInstancesResponse describeReservedInstances(DescribeReservedInstancesRequest describeReservedInstancesRequest) throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeReservedInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedInstances");
            DescribeReservedInstancesResponse describeReservedInstancesResponse = (DescribeReservedInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReservedInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReservedInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReservedInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeReservedInstances$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVpcEndpointsResponse describeVpcEndpoints(DescribeVpcEndpointsRequest describeVpcEndpointsRequest) throws ValidationException, InternalException, DisabledOperationException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVpcEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVpcEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, describeVpcEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVpcEndpoints");
            DescribeVpcEndpointsResponse describeVpcEndpointsResponse = (DescribeVpcEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVpcEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVpcEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVpcEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVpcEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$describeVpcEndpoints$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DissociatePackageResponse dissociatePackage(DissociatePackageRequest dissociatePackageRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DissociatePackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)dissociatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, dissociatePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DissociatePackage");
            DissociatePackageResponse dissociatePackageResponse = (DissociatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DissociatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)dissociatePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DissociatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return dissociatePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$dissociatePackage$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCompatibleVersionsResponse getCompatibleVersions(GetCompatibleVersionsRequest getCompatibleVersionsRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCompatibleVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCompatibleVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, getCompatibleVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCompatibleVersions");
            GetCompatibleVersionsResponse getCompatibleVersionsResponse = (GetCompatibleVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCompatibleVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCompatibleVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCompatibleVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCompatibleVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$getCompatibleVersions$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, DependencyFailureException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, getDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataSource");
            GetDataSourceResponse getDataSourceResponse = (GetDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$getDataSource$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainMaintenanceStatusResponse getDomainMaintenanceStatus(GetDomainMaintenanceStatusRequest getDomainMaintenanceStatusRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainMaintenanceStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainMaintenanceStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, getDomainMaintenanceStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainMaintenanceStatus");
            GetDomainMaintenanceStatusResponse getDomainMaintenanceStatusResponse = (GetDomainMaintenanceStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainMaintenanceStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainMaintenanceStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainMaintenanceStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainMaintenanceStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$getDomainMaintenanceStatus$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPackageVersionHistoryResponse getPackageVersionHistory(GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPackageVersionHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPackageVersionHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, getPackageVersionHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPackageVersionHistory");
            GetPackageVersionHistoryResponse getPackageVersionHistoryResponse = (GetPackageVersionHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPackageVersionHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPackageVersionHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPackageVersionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPackageVersionHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$getPackageVersionHistory$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUpgradeHistoryResponse getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUpgradeHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUpgradeHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, getUpgradeHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUpgradeHistory");
            GetUpgradeHistoryResponse getUpgradeHistoryResponse = (GetUpgradeHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUpgradeHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUpgradeHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUpgradeHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUpgradeHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$getUpgradeHistory$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUpgradeStatusResponse getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUpgradeStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUpgradeStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, getUpgradeStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUpgradeStatus");
            GetUpgradeStatusResponse getUpgradeStatusResponse = (GetUpgradeStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUpgradeStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUpgradeStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUpgradeStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUpgradeStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$getUpgradeStatus$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, DependencyFailureException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDataSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listDataSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataSources");
            ListDataSourcesResponse listDataSourcesResponse = (ListDataSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDataSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listDataSources$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainMaintenancesResponse listDomainMaintenances(ListDomainMaintenancesRequest listDomainMaintenancesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainMaintenancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainMaintenancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listDomainMaintenancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainMaintenances");
            ListDomainMaintenancesResponse listDomainMaintenancesResponse = (ListDomainMaintenancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainMaintenances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainMaintenancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainMaintenancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainMaintenancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listDomainMaintenances$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainNamesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listDomainNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainNames");
            ListDomainNamesResponse listDomainNamesResponse = (ListDomainNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainNames").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainNamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainNamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listDomainNames$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainsForPackageResponse listDomainsForPackage(ListDomainsForPackageRequest listDomainsForPackageRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsForPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainsForPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listDomainsForPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainsForPackage");
            ListDomainsForPackageResponse listDomainsForPackageResponse = (ListDomainsForPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainsForPackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainsForPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainsForPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainsForPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listDomainsForPackage$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstanceTypeDetailsResponse listInstanceTypeDetails(ListInstanceTypeDetailsRequest listInstanceTypeDetailsRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInstanceTypeDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInstanceTypeDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listInstanceTypeDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInstanceTypeDetails");
            ListInstanceTypeDetailsResponse listInstanceTypeDetailsResponse = (ListInstanceTypeDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInstanceTypeDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInstanceTypeDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInstanceTypeDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInstanceTypeDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listInstanceTypeDetails$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPackagesForDomainResponse listPackagesForDomain(ListPackagesForDomainRequest listPackagesForDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackagesForDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPackagesForDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listPackagesForDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPackagesForDomain");
            ListPackagesForDomainResponse listPackagesForDomainResponse = (ListPackagesForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackagesForDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPackagesForDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPackagesForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPackagesForDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listPackagesForDomain$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListScheduledActionsResponse listScheduledActions(ListScheduledActionsRequest listScheduledActionsRequest) throws BaseException, InternalException, ResourceNotFoundException, InvalidPaginationTokenException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListScheduledActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listScheduledActionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listScheduledActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListScheduledActions");
            ListScheduledActionsResponse listScheduledActionsResponse = (ListScheduledActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListScheduledActions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listScheduledActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListScheduledActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listScheduledActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listScheduledActions$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws BaseException, ResourceNotFoundException, ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listTags$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVersionsResponse listVersions(ListVersionsRequest listVersionsRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVersions");
            ListVersionsResponse listVersionsResponse = (ListVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listVersions$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVpcEndpointAccessResponse listVpcEndpointAccess(ListVpcEndpointAccessRequest listVpcEndpointAccessRequest) throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVpcEndpointAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVpcEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listVpcEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVpcEndpointAccess");
            ListVpcEndpointAccessResponse listVpcEndpointAccessResponse = (ListVpcEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVpcEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVpcEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVpcEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVpcEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listVpcEndpointAccess$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVpcEndpointsResponse listVpcEndpoints(ListVpcEndpointsRequest listVpcEndpointsRequest) throws InternalException, DisabledOperationException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVpcEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVpcEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listVpcEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVpcEndpoints");
            ListVpcEndpointsResponse listVpcEndpointsResponse = (ListVpcEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVpcEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVpcEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVpcEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVpcEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listVpcEndpoints$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVpcEndpointsForDomainResponse listVpcEndpointsForDomain(ListVpcEndpointsForDomainRequest listVpcEndpointsForDomainRequest) throws InternalException, DisabledOperationException, ResourceNotFoundException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVpcEndpointsForDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVpcEndpointsForDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, listVpcEndpointsForDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVpcEndpointsForDomain");
            ListVpcEndpointsForDomainResponse listVpcEndpointsForDomainResponse = (ListVpcEndpointsForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVpcEndpointsForDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVpcEndpointsForDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVpcEndpointsForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVpcEndpointsForDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$listVpcEndpointsForDomain$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PurchaseReservedInstanceOfferingResponse purchaseReservedInstanceOffering(PurchaseReservedInstanceOfferingRequest purchaseReservedInstanceOfferingRequest) throws ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseReservedInstanceOfferingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purchaseReservedInstanceOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, purchaseReservedInstanceOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseReservedInstanceOffering");
            PurchaseReservedInstanceOfferingResponse purchaseReservedInstanceOfferingResponse = (PurchaseReservedInstanceOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedInstanceOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)purchaseReservedInstanceOfferingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PurchaseReservedInstanceOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return purchaseReservedInstanceOfferingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$purchaseReservedInstanceOffering$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectInboundConnectionResponse rejectInboundConnection(RejectInboundConnectionRequest rejectInboundConnectionRequest) throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectInboundConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectInboundConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, rejectInboundConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectInboundConnection");
            RejectInboundConnectionResponse rejectInboundConnectionResponse = (RejectInboundConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectInboundConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectInboundConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectInboundConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectInboundConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$rejectInboundConnection$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws BaseException, ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, removeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTags");
            RemoveTagsResponse removeTagsResponse = (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$removeTags$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeVpcEndpointAccessResponse revokeVpcEndpointAccess(RevokeVpcEndpointAccessRequest revokeVpcEndpointAccessRequest) throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeVpcEndpointAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeVpcEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, revokeVpcEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeVpcEndpointAccess");
            RevokeVpcEndpointAccessResponse revokeVpcEndpointAccessResponse = (RevokeVpcEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeVpcEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)revokeVpcEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokeVpcEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeVpcEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$revokeVpcEndpointAccess$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDomainMaintenanceResponse startDomainMaintenance(StartDomainMaintenanceRequest startDomainMaintenanceRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDomainMaintenanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDomainMaintenanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, startDomainMaintenanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDomainMaintenance");
            StartDomainMaintenanceResponse startDomainMaintenanceResponse = (StartDomainMaintenanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDomainMaintenance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDomainMaintenanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDomainMaintenanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDomainMaintenanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$startDomainMaintenance$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartServiceSoftwareUpdateResponse startServiceSoftwareUpdate(StartServiceSoftwareUpdateRequest startServiceSoftwareUpdateRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartServiceSoftwareUpdateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startServiceSoftwareUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, startServiceSoftwareUpdateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartServiceSoftwareUpdate");
            StartServiceSoftwareUpdateResponse startServiceSoftwareUpdateResponse = (StartServiceSoftwareUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartServiceSoftwareUpdate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startServiceSoftwareUpdateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartServiceSoftwareUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startServiceSoftwareUpdateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$startServiceSoftwareUpdate$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, DependencyFailureException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, updateDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataSource");
            UpdateDataSourceResponse updateDataSourceResponse = (UpdateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$updateDataSource$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainConfigResponse updateDomainConfig(UpdateDomainConfigRequest updateDomainConfigRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, updateDomainConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainConfig");
            UpdateDomainConfigResponse updateDomainConfigResponse = (UpdateDomainConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDomainConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$updateDomainConfig$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePackageResponse updatePackage(UpdatePackageRequest updatePackageRequest) throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, updatePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePackage");
            UpdatePackageResponse updatePackageResponse = (UpdatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$updatePackage$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateScheduledActionResponse updateScheduledAction(UpdateScheduledActionRequest updateScheduledActionRequest) throws BaseException, InternalException, ResourceNotFoundException, SlotNotAvailableException, ConflictException, LimitExceededException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateScheduledActionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateScheduledActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, updateScheduledActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateScheduledAction");
            UpdateScheduledActionResponse updateScheduledActionResponse = (UpdateScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScheduledAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateScheduledActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateScheduledActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateScheduledActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$updateScheduledAction$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVpcEndpointResponse updateVpcEndpoint(UpdateVpcEndpointRequest updateVpcEndpointRequest) throws ResourceNotFoundException, DisabledOperationException, InternalException, ValidationException, ConflictException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVpcEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVpcEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, updateVpcEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVpcEndpoint");
            UpdateVpcEndpointResponse updateVpcEndpointResponse = (UpdateVpcEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVpcEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateVpcEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVpcEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVpcEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$updateVpcEndpoint$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeDomainResponse upgradeDomain(UpgradeDomainRequest upgradeDomainRequest) throws BaseException, ResourceNotFoundException, ResourceAlreadyExistsException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradeDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)upgradeDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOpenSearchClient.resolveMetricPublishers(clientConfiguration, upgradeDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpgradeDomain");
            UpgradeDomainResponse upgradeDomainResponse = (UpgradeDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradeDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)upgradeDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpgradeDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return upgradeDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOpenSearchClient.lambda$upgradeDomain$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "es";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        OpenSearchServiceClientConfigurationBuilder serviceConfigBuilder = new OpenSearchServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(OpenSearchException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("DisabledOperationException").exceptionBuilderSupplier(DisabledOperationException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SlotNotAvailableException").exceptionBuilderSupplier(SlotNotAvailableException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyFailureException").exceptionBuilderSupplier(DependencyFailureException::builder).httpStatusCode(Integer.valueOf(424)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTypeException").exceptionBuilderSupplier(InvalidTypeException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
    }

    @Override
    public final OpenSearchServiceClientConfiguration serviceClientConfiguration() {
        return new OpenSearchServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$upgradeDomain$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVpcEndpoint$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateScheduledAction$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePackage$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainConfig$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataSource$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startServiceSoftwareUpdate$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDomainMaintenance$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeVpcEndpointAccess$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTags$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectInboundConnection$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purchaseReservedInstanceOffering$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVpcEndpointsForDomain$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVpcEndpoints$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVpcEndpointAccess$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVersions$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listScheduledActions$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPackagesForDomain$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInstanceTypeDetails$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainsForPackage$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainNames$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainMaintenances$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataSources$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUpgradeStatus$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUpgradeHistory$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPackageVersionHistory$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainMaintenanceStatus$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataSource$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCompatibleVersions$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$dissociatePackage$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVpcEndpoints$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedInstances$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedInstanceOfferings$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePackages$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOutboundConnections$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInstanceTypeLimits$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInboundConnections$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDryRunProgress$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomains$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainNodes$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainHealth$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainConfig$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainChangeProgress$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainAutoTunes$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomain$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVpcEndpoint$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePackage$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOutboundConnection$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInboundConnection$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomain$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataSource$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVpcEndpoint$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPackage$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOutboundConnection$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomain$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelServiceSoftwareUpdate$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelDomainConfigChange$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$authorizeVpcEndpointAccess$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associatePackage$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTags$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addDataSource$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptInboundConnection$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

