/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse;

public class ListDomainMaintenancesPublisher
implements SdkPublisher<ListDomainMaintenancesResponse> {
    private final OpenSearchAsyncClient client;
    private final ListDomainMaintenancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainMaintenancesPublisher(OpenSearchAsyncClient client, ListDomainMaintenancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainMaintenancesPublisher(OpenSearchAsyncClient client, ListDomainMaintenancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainMaintenancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainMaintenancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDomainMaintenancesResponseFetcher
    implements AsyncPageFetcher<ListDomainMaintenancesResponse> {
        private ListDomainMaintenancesResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainMaintenancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDomainMaintenancesResponse> nextPage(ListDomainMaintenancesResponse previousPage) {
            if (previousPage == null) {
                return ListDomainMaintenancesPublisher.this.client.listDomainMaintenances(ListDomainMaintenancesPublisher.this.firstRequest);
            }
            return ListDomainMaintenancesPublisher.this.client.listDomainMaintenances((ListDomainMaintenancesRequest)((Object)ListDomainMaintenancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

