/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DomainState {
    ACTIVE("Active"),
    PROCESSING("Processing"),
    NOT_AVAILABLE("NotAvailable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DomainState> VALUE_MAP;
    private final String value;

    private DomainState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DomainState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DomainState> knownValues() {
        EnumSet<DomainState> knownValues = EnumSet.allOf(DomainState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DomainState.class, DomainState::toString);
    }
}

