/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse;

public class DescribeReservedInstancesPublisher
implements SdkPublisher<DescribeReservedInstancesResponse> {
    private final OpenSearchAsyncClient client;
    private final DescribeReservedInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedInstancesPublisher(OpenSearchAsyncClient client, DescribeReservedInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedInstancesPublisher(OpenSearchAsyncClient client, DescribeReservedInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReservedInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeReservedInstancesResponse> {
        private DescribeReservedInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReservedInstancesResponse> nextPage(DescribeReservedInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesPublisher.this.client.describeReservedInstances(DescribeReservedInstancesPublisher.this.firstRequest);
            }
            return DescribeReservedInstancesPublisher.this.client.describeReservedInstances((DescribeReservedInstancesRequest)((Object)DescribeReservedInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

